package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebView;

import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.model.jsonParsing.ValueRules;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.DateUtils;
import com.tenqube.visual_scraper.utils.Utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import timber.log.Timber;


public class Mall {

    private AppExecutors appExecutors;

    LoginWebRule loginWebRule;
    OrderWebRule orderWebRule;
    OrderDetailWebRuleJson orderDetailWebRuleJson;
    OrderApiRuleJson orderApiRuleJson;

    final ScrapRepository repository;
    private WebViewManager webViewManager;
    public MallData mallData;
//    private Preference preference;

    public Mall(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        this.mallData = mallData;
        this.repository = repository;

        appExecutors = new AppExecutors();
        this.webViewManager = webViewManager;
    }

    public void startWebViewLogin(@NonNull LoginWebRule loginWebRule, @NonNull UserEntity user, int crud, @NonNull final ScrapService.OnResult<List<OrderEntity>> onResult) {
        // 룰에 따른 scripts param 구하기 및 구성
        Utils.getFinalLoginWebRule(loginWebRule, user.getUserId(), user.getUserPwd().getValue());
        this.loginWebRule = loginWebRule;

//        appExecutors.mainThread().execute(() -> {
            webViewManager.setWebUrl(loginWebRule.getUrl().finalQuery)
                    .setScripts(loginWebRule.getLoginScripts().finalQuery)
                    .setAction(WebViewManager.LOGIN)
                    .build(new WebViewManager.WebViewCallback() {
                        @Override
                        public void onResult(String cookie, WebView webView) {
                            // login success
                            //3. 파싱룰 정보 로드
                            Timber.i("startWebViewLogin"+"login Success : cookie "+cookie+"/"+webView);
                            // user 정보 저장
                            if (crud != 0) {
//                                user.setCookie(cookie); // 안해도될것같음
                                user.setLogin(true);
                                Timber.i("insertUser"+"user : "+user);
                                repository.insertUsers(user);
                            }

                            repository.getOrderWebRule(user.getMallId(),(webRule) -> {

                                Timber.i("getOrderWebRule"+"info : "+ webRule);

                                if (webRule != null) {
                                    orderWebRule = webRule;
                                    if (orderWebRule.getUrl() != null) orderWebRule.getUrl().finalQuery = Utils.getOrderValue(orderWebRule.getUrl(), user.getLastScrapAt());
                                    if (orderWebRule.getPeriodScripts() != null) orderWebRule.getPeriodScripts().finalQuery = Utils.getOrderValue(orderWebRule.getPeriodScripts(), user.getLastScrapAt());
                                    Timber.i("getOrderWebRule"+"final_info : "+ orderWebRule);

                                    repository.getDetailHtmlRule(user.getMallId(), (detailWebRule)-> {

                                        orderDetailWebRuleJson = detailWebRule;
                                        //4. 파싱
                                        parseWeb(user, cookie, onResult, items -> {
                                            Timber .i("parseWeb" + "items : "+ items);

                                            //  성공시 데이터 저장
                                            if (items != null && items.size() != 0) {
                                                repository.insertOrders(items, (insertedList -> {
                                                    Timber.i("success"+"item :" +items.size() + "/" +insertedList.size());
                                                    // 실제 저장된 리스트만 보내줌
                                                    onResult.onSuccess(user.getMallId(), insertedList, mallData.getDisplayName()+" 갯수 : "+insertedList.size());
                                                    // 서버 동기화
                                                    if (insertedList.size() > 0) repository.callInsertOrderList();
                                                }));
                                            } else {
                                                onResult.onSuccess(user.getMallId(), null, mallData.getDisplayName()+"/구매내역없음");
                                            }
                                        });


                                    });

                                } else {
                                    onResult.onFail(user.getMallId(), Constants.ERROR.NOT_FOUND_RULE, mallData.getDisplayName() + " login_web");
                                }
                            });

                        }

                        @Override
                        public void onFail(int statusCode, String statusMessage) {
                            Timber.i("login_web"+"onFail : "+ statusCode +"/"+statusMessage);
                            onResult.onFail(user.getMallId(), Constants.ERROR.LOGIN_FAIL, statusMessage);
                        }
                    });
//        };

    }

    private void parseWeb(UserEntity user, String cookie, ScrapService.OnResult onResult, ScrapService.Callback<List<OrderEntity>> callback) {
        List<OrderEntity> orders = new ArrayList<>();

        Runnable runnable = () -> getOrderPageDocument(cookie, orderWebRule, new OrderCallback<Document>() {
            @Override
            public void onResult(Document document) {

                List<OrderHtml> orderHtmls = convertToOrderHtmlList(document);
                Timber.i("parseWeb" + "orderHtmls size : " + orderHtmls.size() + " orderHtmls : " + orderHtmls);

                orders.addAll(convertToOrderEntity(orderHtmls, orderDetailWebRuleJson));

                // lastSycDate update 하기
                long lastScrapAt = Utils.getLastScrapAt();
                repository.updateUserLastScrapAt(lastScrapAt, user.getMallId(), user.getUserId());

                appExecutors.mainThread().execute(() -> callback.onDataLoaded(orders));
            }

            @Override
            public void onFail(int statusCode, String statusMessage) {
                appExecutors.mainThread().execute(() -> onResult.onFail(user.getMallId(), Constants.ERROR.PARSING_FAIL, mallData.getDisplayName() + statusMessage));
            }

        });
        appExecutors.networkIO().execute(runnable);


    }

    private List<OrderHtml> convertToOrderHtmlList(Document document) {

        // pave_div, container
        Elements elements = getElements(document, orderWebRule);

        List<OrderHtml> orderHtmls = new ArrayList<>(getOrderHtmls(elements, orderWebRule));


        if (orderHtmls.size() == 0 && !TextUtils.isEmpty(orderWebRule.getContainer().equation)) {
            elements = document.select(String.format(orderWebRule.getContainer().selector, "n"));

            orderHtmls.addAll(getOrderHtmls(elements, orderWebRule));
        }

        return orderHtmls;
    }

    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        List<OrderHtml> orderHtmls = new ArrayList<>();

        Timber.i("parseWeb"+"element_size : "+elements.size());
        for (Element element : elements) {
            try {
                OrderHtml orderHtml = parseHtml(element);
                if (orderHtml != null) orderHtmls.add(orderHtml);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        return orderHtmls;
    }

    private Elements getElements(Document document, OrderWebRule orderWebRule) {
        Elements elements;

        if (TextUtils.isEmpty(orderWebRule.getContainer().equation)) {

            elements = document.select(orderWebRule.getContainer().selector);
        } else {

            elements = document.select(String.format(orderWebRule.getContainer().selector, orderWebRule.getContainer().equation));
        }

        return elements;
    }


    private List<OrderEntity> convertToOrderEntity(List<OrderHtml> orderHtmls, @Nullable OrderDetailWebRuleJson orderDetailWebRule) {

        List<OrderEntity> orders = new ArrayList<>();
        for (OrderHtml orderHtml : orderHtmls) {
//            Timber.i("filter","orderHtml : "+orderHtml);
            try {
                OrderEntity order = new OrderEntity();
                order.mId = orderWebRule.getMallId();
//                order.uId
                order.title = titleFilter(orderHtml.title); // 필수
                order.orderDate = orderDateFilter(orderHtml.orderDate);
                order.orderHms = orderHmsFilter(orderHtml.orderHms);
                order.orderOption = orderOptionFilter(orderHtml.orderOption);
                order.quantity = quantityFilter(orderHtml.quantity);
                order.price = priceFilter(orderHtml.price);
                order.orderNum = orderNumFilter(orderHtml.orderNum);
                order.orderState = orderStateFilter(orderHtml.orderState);
                order.imgUrl = imgUrlFilter(orderHtml.imgUrl);
                order.currency = currencyFilter(orderHtml.price); //"KRW";
                order.detailOrderLink = TextUtils.isEmpty(orderHtml.detailOrderLink) ?
                        getDetailOrderLink(order.orderNum, orderDetailWebRule)
                        :
                        orderHtml.detailOrderLink;
                order.detailProductLink = orderHtml.detailProdLink;

                Timber.i("filter"+"info : "+ order);
                if(!isValid(order)) continue;


                orders.add(order);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return orders;
    }

    private boolean isValid(OrderEntity order) {
        return !TextUtils.isEmpty(order.title) && order.orderDate != null && !TextUtils.isEmpty(order.orderNum);

    }

    private String getDetailOrderLink(String orderNum, @Nullable OrderDetailWebRuleJson orderDetailWebRule) {
        if(orderDetailWebRule != null) {
            QueryRuleBody urlBody = orderDetailWebRule.getUrl();
            Timber.i("detailUrl"+""+urlBody+"//"+orderNum);
            if (urlBody != null) {

                if (orderDetailWebRule.getRequestBody() == null) {
                    return Utils.getFinalDetailUrl(urlBody, orderNum);
                } else {
                    String url = urlBody.query;

                    ArrayList<String> postDatas = new ArrayList<>();
                    String query = orderDetailWebRule.getRequestBody().query;


                    for(ValueRules value : orderDetailWebRule.getRequestBody().values) {

                        if("orderNum".equals(value.rule)) {
                            try {
                                postDatas.add(URLEncoder.encode(orderNum, "UTF-8"));
                            } catch (UnsupportedEncodingException e) {
                                postDatas.add(orderNum);
                            }
                        }
                    }

                    String postData =  String.format(query, postDatas);

                    return "post\t" + url  + "\t" + postData;
                }
            }
        }

        return "";
    }

    /**
     * jsoup 은 자바스크립트코드로 못돌림.
     * 1. jsoup 요청 with cookie
     * @param cookie 쿠키정보
     */
    private void getOrderPageDocument(String cookie, OrderWebRule orderWebRule, OrderCallback<Document> orderCallback /*, Map<String, String> queryParams, int methodType*/) {
        try {

            webViewManager.setWebUrl(orderWebRule.getUrl().finalQuery)
                    .setScripts(orderWebRule.getPeriodScripts() == null ? null :orderWebRule.getPeriodScripts().finalQuery)
                    .setAction(WebViewManager.ORDER_PARSING)
                    .build(new WebViewManager.WebViewCallback() {
                        @Override
                        public void onResult(String html, WebView webView) {
                            // document 얻기
                            Document document = Jsoup.parse(html, orderWebRule.getUrl().finalQuery);
//                            Timber.i("getOrderPageDocument", "document : " + document);
                            if (document != null) orderCallback.onResult(document);
                        }

                        @Override
                        public void onFail(int statusCode, String statusMessage) {
                            Timber.i("login_web"+ "onFail : " + statusCode + "/" + statusMessage);
                            orderCallback.onFail(statusCode, statusMessage);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            orderCallback.onFail(403, "getOrderPageDocument crash");
        }

    }

    interface OrderCallback<T> {
        void onResult(T document);
        void onFail(int statusCode, String statusMessage);
    }



    protected OrderHtml parseHtml(@NonNull Element element) {
        OrderHtml order = new OrderHtml();
        order.title = parseValue(element, orderWebRule.getTitle());
        order.orderDate = parseValue(element, orderWebRule.getOrderDate());
        order.orderHms = parseValue(element,orderWebRule.getOrderHms());
        order.orderOption = parseValue(element, orderWebRule.getOrderOption());
        order.quantity = parseValue(element, orderWebRule.getQuantity());
        order.price = parseValue(element, orderWebRule.getPrice());
        order.orderNum = parseValue(element, orderWebRule.getOrderNum());
        order.orderState = parseValue(element, orderWebRule.getOrderState());
        order.imgUrl = parseValue(element, orderWebRule.getImgUrl());
        order.detailOrderLink = parseValue(element, orderWebRule.getDetailOrderLink());
        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink());
        Timber.i("parseHtml"+"order : "+order);
        if (TextUtils.isEmpty(order.title) /*|| TextUtils.isEmpty(order.orderDate)*/
                /*|| TextUtils.isEmpty(order.price)*/ || TextUtils.isEmpty(order.orderNum)) return null;
        return order;
    }

    protected String titleFilter(@NonNull String title) {
        return title;
    }

    protected Date orderDateFilter(@NonNull String orderDate) {
        return TextUtils.isEmpty(orderDate) ? null : DateUtils.transformDate(orderDate, Constants.DateFormatType.DASH);
    }

    protected Date orderHmsFilter(@NonNull String orderHms) {
        return TextUtils.isEmpty(orderHms) ? null : DateUtils.transformHms(orderHms);
    }

    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption;
    }

    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException  {
        return TextUtils.isEmpty(quantity)? 1 : Integer.parseInt(quantity);
    }

    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return TextUtils.isEmpty(price) ? 0 : Double.parseDouble(price.replace(",","").replace("원",""));
    }

    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum;
    }

    protected String orderStateFilter(@NonNull String orderState) {
        return orderState;
    }

    protected String imgUrlFilter(@NonNull String imgUrl) {
        return imgUrl;
    }

    protected String currencyFilter(@NonNull String price) {
        return price.contains(".") ? "USD" : "KRW";
    }

    String parseValue(Element element, ParsingOrderRules parsingOrderRules) {
        String key;
        String attr;
        int pos = 0;
        if (parsingOrderRules == null) {
            return "";
        } else {
            key = parsingOrderRules.selector;
            attr = parsingOrderRules.attribute;
        }

        String result = "";
        Timber.i("parseValue"+"key : "+key+"/attr : "+attr);
        try {

            if(!TextUtils.isEmpty(key)) {
                if (key.contains("br")) {
                    key = key.replace("br","b");
                    int classPos = key.indexOf(".");
                    int classPosEnd = key.indexOf(" ", classPos);
                    String classKey = key.substring(classPos, classPosEnd);
                    Element tempValue = element.select(classKey).get(0);/*.get(pos);*/
                    Element replace = Jsoup.parse(tempValue.toString().replace("br","b"));
                    Timber.i("parseValue"+"replace : "+replace);
                    element = replace;
                }

                Element value = element.select(key).first();//.get(0/*pos*/);

                Timber.i("parseValue"+"value : "+value);
                if (value != null) {
                    if(TextUtils.isEmpty(attr)) {
                        result = value.text();
                    } else {
//                    result = value.html();
                        if (attr.contains("href")) {
                            result = value.absUrl("href"); // result = value.attr("abs:href"); 같음
//                            Timber.i("parseValue","absUrl : "+result);

                        } else {
                            result = value.attr(attr);
//                            Timber.i("parseValue","attr : "+result);
                        }
                    }
                }

                Timber.i("parseValue"+"result : "+result);
            }
        } catch (Exception e) {
            result = "";
            e.printStackTrace();
        }

        return result;
    }

    public boolean doCheckLoginError() {
        return loginWebRule.getFailMessage() != null && !TextUtils.isEmpty(loginWebRule.getFailMessage().selector);
    }

    public boolean doCheckLoginCaptcha() {
        return loginWebRule.getCaptchaContainer() != null && !TextUtils.isEmpty(loginWebRule.getCaptchaContainer().selector);
    }

    public String checkLoginError(Document document) {
        /**
         * null
         * gmarket 웹은 팝업창 / 모바일이므로 없음
         *
         */
        return doCheckLoginError() ? checkLoginErrorClass(document) : "";

    }

    protected String checkLoginErrorClass(Document document) {
        Timber.i("checkLoginErrorClass"+ "failMessage : "+loginWebRule.getFailMessage());
        Elements elements = document.select(loginWebRule.getFailMessage().selector);
        Timber.i("checkLogin"+"elements_size : " + elements.size());

        if (elements.size() > 0) return elements.first().text();
        return "";
    }

    public boolean checkCaptchaImage(Document document){

        // 각 몰마다 captcha 요소 잇는지 체크

        return doCheckLoginCaptcha() && checkCaptchaClass(document);

    }

//    protected boolean checkVerifyPage(Document document) {
//
//        return
//    }

    protected boolean checkCaptchaClass(Document document) {
        Elements elements = document.select(loginWebRule.getCaptchaContainer().selector);
        Timber.i("checkCaptchaClass" + "size : "+elements.size() + "/container : "+loginWebRule.getCaptchaContainer());
        return elements.size() != 0;
    }

    public boolean identifyLoginPageOrNot(String url) {
        return checkLoginPageOrNot(url);
    }

    protected boolean checkLoginPageOrNot(String url) {
        return url.contains("Login") || url.contains("login");
    }

    public boolean doParsingMall() {
        return mallData.getKeyName().equalsIgnoreCase(Constants.DEFAULT_MALL.Interpark);
    }

    public void setWebviewSettings(int action, WebView webView) {
        setUserAgentString(action, webView);
    }

    protected void setUserAgentString(int action, WebView webView) {

    }

}
