package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.utils.Utils;

import java.io.Serializable;


@Entity(tableName = "malls",
        indices = {@Index(value = {"m_id"}, unique = true)})
public class MallEntity implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "m_id")
    private final int id;


    @ColumnInfo(name = "name")
    private final String name;

    @NonNull
    @ColumnInfo(name = "display_name")
    private final String displayName;

    @NonNull
    @ColumnInfo(name = "domain")
    private final String domain;

    @ColumnInfo(name = "icon_url")
    private final String iconUrl;

    @ColumnInfo(name = "logo_url")
    private final String logoUrl;

    @NonNull
    @ColumnInfo(name = "is_active")
    private final int isActive;

    @NonNull
    @ColumnInfo(name = "isLoginTypeJson")
    private final int isLoginTypeJson;

    @NonNull
    @ColumnInfo(name = "isOrderTypeJson")
    private final int isOrderTypeJson;

    @ColumnInfo(name = "version")
    private final int version;

    @ColumnInfo(name = "find_id_url")
    private final String findIdUrl;

    @ColumnInfo(name = "find_pwd_url")
    private final String findPwUrl;

    @Ignore
    private final int iconResId;

    public MallEntity(int id, String name, @NonNull String displayName, @NonNull String domain,
                      @NonNull String logoUrl,
                      @NonNull String iconUrl,
                      @NonNull int isActive, @NonNull int isLoginTypeJson, @NonNull int isOrderTypeJson, @NonNull int version,
                      String findIdUrl, String findPwUrl) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.domain = domain;
        this.logoUrl = logoUrl;
        this.iconUrl = iconUrl;
        this.isActive = isActive;
        this.isLoginTypeJson = isLoginTypeJson;
        this.isOrderTypeJson = isOrderTypeJson;
        this.version = version;
        this.findIdUrl = findIdUrl;
        this.findPwUrl = findPwUrl;
        iconResId = Utils.getMallResId(name);
    }

    public int getIconResId() {
        return iconResId;
    }

    public String getName() {
        return name;
    }

    public int getId() {
        return id;
    }

    @NonNull
    public String getDisplayName() {
        return displayName;
    }

    @NonNull
    public String getDomain() {
        return domain;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    @NonNull
    public boolean isActive() {
        return isActive == 1;
    }

    @NonNull
    public boolean isLoginTypeJson() {
        return isLoginTypeJson == 1;
    }

    @NonNull
    public boolean isOrderTypeJson() {
        return isOrderTypeJson == 1;
    }

    public int getIsActive() {
        return isActive;
    }

    public int getIsLoginTypeJson() {
        return isLoginTypeJson;
    }

    public int getIsOrderTypeJson() {
        return isOrderTypeJson;
    }

    @NonNull
    public int getVersion() {
        return version;
    }

    public String getFindIdUrl() {
        return findIdUrl;
    }

    public String getFindPwUrl() {
        return findPwUrl;
    }

    @Override
    public String toString() {
        return "MallEntity{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", displayName='" + displayName + '\'' +
                ", domain='" + domain + '\'' +
                ", iconUrl='" + iconUrl + '\'' +
                ", isActive=" + isActive +
                ", isLoginTypeJson=" + isLoginTypeJson +
                ", isOrderTypeJson=" + isOrderTypeJson +
                ", version=" + version +
                ", findIdUrl='" + findIdUrl + '\'' +
                ", findPwUrl='" + findPwUrl + '\'' +
                '}';
    }
}
