package com.tenqube.visual_scraper.api;

import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;

import java.io.IOException;
import java.net.URISyntaxException;

import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import static com.tenqube.visual_scraper.constants.Constants.API.AUTHORIZATION;

public class HeaderInterceptor implements Interceptor {

    private final SharedPreferences preferences;

    public HeaderInterceptor(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        HttpUrl host = HttpUrl.parse(String.format(ScrapApiService.BASE_URL, preferences.getString(Constants.PREF_KEY.LAYER, "dev")));
        HttpUrl newUrl = null;
        try {
            newUrl = chain.request().url().newBuilder().scheme(host.scheme()).host(host.url().toURI().getHost()).port(host.port()).build();
        } catch (URISyntaxException e) {
            e.printStackTrace();
            newUrl = host;
        }
        // 분기
//        Log.i("HeaderInterceptor", "url :"+new/**/Url.url());
        Request.Builder builder = chain.request()
                .newBuilder()
                .url(newUrl)
                .addHeader(Constants.API.X_API_KEY, preferences.getString(Constants.PREF_KEY.X_API_KEY, ""))
                .addHeader(Constants.API.CONTENT_TYPE, "application/json");

        if (!newUrl.url().getPath().contains("signUp")) {
            builder = builder.addHeader(AUTHORIZATION, preferences.getString(Constants.PREF_KEY.TOKEN,"0da3fd3c0c3f25ca240780d56086eeddc9b6d8477e9dd7f6a86203b91eba33d10ec04ff28413714ade6c8f4937a831f971ba9d56555f723c221596a3c9b20c0a569d98eda74057a193b01834e47f96d1f20ec35c27eb98"));
        }
        Log.i("HeaderInterceptor", "x_API : "+preferences.getString(Constants.PREF_KEY.X_API_KEY, ""));
        Log.i("HeaderInterceptor", "AUTHORIZATION : "+preferences.getString(Constants.PREF_KEY.TOKEN,"0da3fd3c0c3f25ca240780d56086eeddc9b6d8477e9dd7f6a86203b91eba33d10ec04ff28413714ade6c8f4937a831f971ba9d56555f723c221596a3c9b20c0a569d98eda74057a193b01834e47f96d1f20ec35c27eb98"));

        return chain.proceed(builder.build());
    }

}
