/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;

public class Gshome
extends Mall {
    public Gshome(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.DOT);
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        if (!TextUtils.isEmpty((CharSequence)imgUrl) && !imgUrl.equals("http")) {
            imgUrl = "http:" + imgUrl;
        }
        return imgUrl;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            return Integer.parseInt(quantity.replace("\uac1c", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        try {
            return Double.parseDouble(price.replace(",", "").replace("\uc6d0", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }
}

