/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.util.List;

public class OrderDetailWebRuleDao_Impl
implements OrderDetailWebRuleDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfOrderDetailWebRuleJson;

    public OrderDetailWebRuleDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderDetailWebRuleJson = new EntityInsertionAdapter<OrderDetailWebRuleJson>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `order_detail_web_rule`(`_id`,`mall_id`,`url`,`request_body`) VALUES (nullif(?, 0),?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderDetailWebRuleJson value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                String _tmp = QueryRuleConverter.fromOrderRules(value.getUrl());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRequestBody());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(OrderDetailWebRuleJson orderDetailWebRule) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfOrderDetailWebRuleJson.insertAndReturnId((Object)orderDetailWebRule);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertList(List<OrderDetailWebRuleJson> orderDetailWebRules) {
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfOrderDetailWebRuleJson.insertAndReturnIdsList(orderDetailWebRules);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderDetailWebRuleJson getInfo(int mId) {
        String _sql = "SELECT * FROM order_detail_web_rule WHERE mall_id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM order_detail_web_rule WHERE mall_id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)mId);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            OrderDetailWebRuleJson _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfMallId = _cursor.getColumnIndexOrThrow("mall_id");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
            int _cursorIndexOfRequestBody = _cursor.getColumnIndexOrThrow("request_body");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmp = _cursor.getString(_cursorIndexOfUrl);
                QueryRuleBody _tmpUrl = QueryRuleConverter.toParsingOrderRule(_tmp);
                String _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
                _result = new OrderDetailWebRuleJson(_tmpMallId, _tmpUrl, _tmpRequestBody);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            OrderDetailWebRuleJson orderDetailWebRuleJson = _result;
            return orderDetailWebRuleJson;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

