/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;

public class Interpark
extends Mall {
    public Interpark(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        try {
            return Double.parseDouble(price.split("\\(")[0].replace(",", "").replace("\uc6d0", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            String[] str = quantity.split("\\(");
            if (str.length > 1) {
                return Integer.parseInt(str[1].replace(")", "").replace("\uac1c", ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty((CharSequence)orderDate) && orderDate.length() > 7 ? orderDate.substring(0, 8) : "";
        return DateUtils.transformDate(date, Constants.DateFormatType.NONE);
    }
}

