/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.google.gson.Gson;
import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.model.jsonParsing.ValueRules;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class Utils {
    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm;
            boolean bl = hasPerm = ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0;
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    private static String getAndroidId(Context context) {
        try {
            String androidDeviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            return androidDeviceId;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void getFinalLoginWebRule(LoginWebRule loginWebRule, String userId, String password) {
        String finalStr;
        List<Object> param;
        QueryRuleBody urlBody = loginWebRule.getUrl();
        QueryRuleBody scriptsBody = loginWebRule.getLoginScripts();
        if (urlBody.values == null) {
            loginWebRule.getUrl().finalQuery = urlBody.query;
        } else {
            param = Utils.getLoginParam(urlBody, userId, password);
            Log.i((String)"getFinalLoginWebRule", (String)("param : " + param + "/" + urlBody.query));
            finalStr = String.format(urlBody.query, param.toArray());
            Log.i((String)"login", (String)("webview : " + finalStr));
            loginWebRule.getUrl().finalQuery = finalStr;
        }
        if (scriptsBody.values == null) {
            loginWebRule.getLoginScripts().finalQuery = scriptsBody.query;
        } else {
            param = Utils.getLoginParam(scriptsBody, userId, password);
            Log.i((String)"getFinalLoginWebRule", (String)("param : " + param + "/" + scriptsBody.query));
            finalStr = String.format(scriptsBody.query, param.toArray());
            Log.i((String)"getFinalLoginWebRule", (String)("webview : " + finalStr));
            loginWebRule.getLoginScripts().finalQuery = finalStr;
        }
        Log.i((String)"final", (String)("loginWebRule : " + loginWebRule));
    }

    public static List<Object> getLoginParam(QueryRuleBody queryRuleBody, String userId, String password) {
        ArrayList<Object> strArray = new ArrayList<Object>();
        if (queryRuleBody.values != null) {
            for (ValueRules v : queryRuleBody.values) {
                if (v.rule.equals("id")) {
                    strArray.add(userId);
                    continue;
                }
                if (!v.rule.equals("pw")) continue;
                strArray.add(password);
            }
        }
        return strArray;
    }

    public static String getOrderValue(QueryRuleBody queryRuleBody, long lastScrapAt) {
        return queryRuleBody.values != null ? String.format(queryRuleBody.query, Utils.getOrderParam(queryRuleBody, lastScrapAt).toArray()) : queryRuleBody.query;
    }

    public static String getFinalDetailUrl(QueryRuleBody queryRuleBody, String orderNum) {
        ArrayList strArray = new ArrayList();
        if (queryRuleBody.values != null) {
            for (ValueRules v : queryRuleBody.values) {
                if (!v.rule.equals("orderNum")) continue;
                strArray.add(strArray);
            }
        }
        queryRuleBody.finalQuery = String.format(queryRuleBody.query, orderNum);
        return queryRuleBody.finalQuery;
    }

    public static ArrayList<Object> getOrderParam(QueryRuleBody queryRuleBody, long lastScrapAt) {
        ArrayList<Object> param = new ArrayList<Object>();
        for (ValueRules v : queryRuleBody.values) {
            String[] s;
            if (v.rule.equals("date")) {
                s = DateUtils.getDateFormat(v.format, v.range, lastScrapAt);
                Log.i((String)"date", (String)("s : " + (String)s));
                param.add(s);
                continue;
            }
            if (!v.rule.equals("choice")) continue;
            s = v.option.split("/");
            Log.i((String)"choice", (String)("s : " + s[0]));
            param.add(s[0]);
        }
        return param;
    }

    public static long getLastScrapAt() {
        return new Date().getTime();
    }

    public static <T> T parseJsonObject(String input, Class<T> tClass) {
        try {
            return TextUtils.isEmpty((CharSequence)input) ? null : (T)Utils.fromJson(input, tClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> T fromJson(String param, Class<T> classOfT) throws Exception {
        Gson gson = new Gson();
        return (T)gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static String loadJSONFromAsset(@NonNull Context context, String fileName) {
        String json = null;
        try {
            AssetManager am = context.getAssets();
            InputStream is = am.open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public static int calculateEquation(String equation) {
        int result = 0;
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("rhino");
            result = new BigDecimal(engine.eval(equation).toString()).intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)"calculateEquation", (String)("result :" + result));
        return result;
    }

    public static List<OrderInfo> convertOrderInfo(@NonNull List<OrderEntity> list, @NonNull SparseArray<MallEntity> mallEntitySparseArray) {
        ArrayList<OrderInfo> results = new ArrayList<OrderInfo>();
        for (OrderEntity orderEntity : list) {
            if (mallEntitySparseArray.get(orderEntity.getmId()) == null) continue;
            String iconUrl = ((MallEntity)mallEntitySparseArray.get(orderEntity.getmId())).getIconUrl();
            int iconResId = Utils.getMallResId(((MallEntity)mallEntitySparseArray.get(orderEntity.getmId())).getName());
            results.add(new OrderInfo(orderEntity._id, orderEntity.mId, orderEntity.uId, orderEntity.title, orderEntity.orderDate, orderEntity.orderHms, orderEntity.orderOption, orderEntity.quantity, orderEntity.price, orderEntity.currency, orderEntity.orderNum, orderEntity.orderState, orderEntity.imgUrl, orderEntity.detailOrderLink, orderEntity.detailProductLink, iconResId, iconUrl));
        }
        return results;
    }

    public static int getMallResId(String name) {
        switch (name) {
            case "Auction": {
                return R.drawable.logo_auction;
            }
            case "Coupang": {
                return R.drawable.logo_coupang;
            }
            case "ElevenStreet": {
                return R.drawable.logo_11st;
            }
            case "Gmarket": {
                return R.drawable.logo_gmarket;
            }
            case "Gshome": {
                return R.drawable.logo_gsshop;
            }
            case "Hmall": {
                return R.drawable.logo_hmall;
            }
            case "Interpark": {
                return R.drawable.logo_interpark;
            }
            case "LotteHome": {
                return R.drawable.logo_lotte;
            }
            case "NaverPay": {
                return R.drawable.logo_naver;
            }
            case "Tmon": {
                return R.drawable.logo_tmon;
            }
            case "Wemake": {
                return R.drawable.logo_wemakeprice;
            }
        }
        return 0;
    }
}

