package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import java.util.Date;

public class Coupang extends Mall {

    private static final String URL = "https://my.coupang.com";

    public Coupang(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    protected Document makeDocument(Document document) {

        return Jsoup.parse(document.html().replace(" ,=\"\"", ""));

    }

    @Override
    protected String titleFilter(@NonNull String title) {
        return super.titleFilter(title);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.SLASH);
    }



    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        if(!TextUtils.isEmpty(orderNum) && orderNum.contains("/")) {
            String[] orders = orderNum.split("/");
            if(orders.length > 3) {
                return orders[3];
            }
        }
        return "";
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {

        return TextUtils.isEmpty(orderState) ? "": orderState.replaceAll("\\d+", "").replace("\n", "");
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        int result = 1;
        try {
            if(!TextUtils.isEmpty(quantity)) {
                String[] temps = quantity.split("/");
                if (temps.length > 1) {
                    result = Integer.parseInt(temps[1].replace("개","").trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        //'12,490원 / 1개'
        if(!TextUtils.isEmpty(price)) {
            String[] temps = price.split("/");

            if(temps.length >= 1) {
                return Double.parseDouble(temps[0].replace(",", "").replace("원", "").trim());
            }
        }
        return 0;
    }



}
