package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;

import org.jsoup.nodes.Element;

public class ElevenStreet extends Mall {
    private final String PRODUCT_URL = "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s&xfrom=&xzone=";

    public ElevenStreet(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderNum(), 0, null);
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
////        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink(), 0, "href");
//
//        return order;
//    }

    @Override
    protected String orderDateFilter(@NonNull String orderDate) {
        //2018-04-19 (201804197627389)
        try {
            if (!TextUtils.isEmpty(orderDate)) {
                return orderDate.substring(0, orderDate.indexOf("(") -1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty(orderNum) && orderNum.length() > 1) {
                return orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")") -1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

//    @Override
//    protected String detailProductLinkFilter(@NonNull String detailProductLink) {
//        if (!TextUtils.isEmpty(detailProductLink)) {
//            String[] temps = detailProductLink.split(",");
//            if (temps.length > 3) {
//                String prodNo = temps[3].replace("'","").trim();
//                return String.format(PRODUCT_URL, prodNo);
//            }
//        }
//        return "";
//    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        //36,400원 (1개)
        int result = 1;
        try {

            if (!TextUtils.isEmpty(quantity)) {
                result = Integer.parseInt(quantity.substring(quantity.indexOf("(") + 1, quantity.indexOf(")")).replace("개","").trim());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replaceAll("원","").replaceAll(",",""));
    }
}
