package com.tenqube.visual_scraper.model.api;

import com.google.gson.Gson;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;

import java.io.Serializable;

/**
 * Created by tenqube on 2018. 6. 1..cw.jeon
 */

public class Order implements Serializable {

    // 필수
    public String title;
    // 필수
    public String orderDate;

    // 예외걸기 (필수아닌거)
    public String orderHms;
    public String orderOption;

    // default 1
    public int quantity;
    // 필수
    public int price;
    // 필수
    public String orderNum;

    public String orderState;

    // 필수
    public String imgUrl;

    public DetailOrder detailOrder;
    public String detailProdLink;

    public static class DetailOrder implements Serializable {

        public String link;
        public String params;
        public int methodType;

        @Override
        public String toString() {
            return "DetailOrder{" +
                    "link='" + link + '\'' +
                    ", params=" + params +
                    ", methodType=" + methodType +
                    '}';
        }

        public String toJson() {
            Gson gson = new Gson();
            return gson.toJson(this);
        }
    }

    @Override
    public String toString() {
        return "Order{" +
                "title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity=" + quantity +
                ", price=" + price +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", detailOrderLink=" + detailOrder +
                ", detailProdLink='" + detailProdLink + '\'' +
                '}';
    }

//    public OrderEntity toEntity(int uid) {
//
//        String jsonDetailOrder = detailOrderLink == null? "" : detailOrderLink.toJson();
//        return new OrderEntity(0, uid, title, orderDate, orderHms, orderOption, quantity, price, orderNum, orderState, imgUrl, jsonDetailOrder, detailProdLink);
//    }
}
