/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.view.OrderWebRule;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Tmon
extends Mall {
    public Tmon(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        ArrayList<OrderHtml> orderHtmls = new ArrayList<OrderHtml>();
        try {
            if (!TextUtils.isEmpty((CharSequence)orderWebRule.getTitle().equation)) {
                List<String> title = this.parseEquation(elements, orderWebRule.getTitle());
                List<String> orderDate = this.parseEquation(elements, orderWebRule.getOrderDate());
                List<String> orderHms = this.parseEquation(elements, orderWebRule.getOrderHms());
                List<String> orderOption = this.parseEquation(elements, orderWebRule.getOrderOption());
                List<String> quantity = this.parseEquation(elements, orderWebRule.getQuantity());
                List<String> price = this.parseEquation(elements, orderWebRule.getPrice());
                List<String> orderNum = this.parseEquation(elements, orderWebRule.getOrderNum());
                List<String> orderState = this.parseEquation(elements, orderWebRule.getOrderState());
                List<String> imgUrl = this.parseEquation(elements, orderWebRule.getImgUrl());
                List<String> detailOrderLink = this.parseEquation(elements, orderWebRule.getDetailOrderLink());
                List<String> detailProdLink = this.parseEquation(elements, orderWebRule.getDetailProductLink());
                for (int i = 0; i < title.size(); ++i) {
                    OrderHtml orderHtml = new OrderHtml();
                    orderHtml.title = title.get(i);
                    orderHtml.orderDate = orderDate.get(i);
                    orderHtml.orderHms = orderHms == null ? "" : orderHms.get(i);
                    orderHtml.orderOption = orderOption == null ? "" : orderOption.get(i);
                    orderHtml.quantity = quantity == null ? "" : quantity.get(i);
                    orderHtml.price = price.get(i);
                    orderHtml.orderNum = orderNum.get(i);
                    orderHtml.orderState = orderState == null ? "" : orderState.get(i);
                    orderHtml.imgUrl = imgUrl == null ? "" : imgUrl.get(i);
                    orderHtml.detailOrderLink = detailOrderLink == null ? "" : detailOrderLink.get(i);
                    orderHtml.detailProdLink = detailProdLink == null ? "" : detailProdLink.get(i);
                    Log.i((String)"parseWeb", (String)("parsed_orderHtml : " + orderHtml));
                    orderHtmls.add(orderHtml);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderHtmls;
    }

    private List<String> parseEquation(Elements elements, ParsingOrderRules parsingOrderRules) {
        ArrayList<String> results = new ArrayList<String>();
        if (parsingOrderRules != null) {
            String key;
            parsingOrderRules.selector = key = String.format(parsingOrderRules.selector, parsingOrderRules.equation);
            Elements elements1 = elements.select(key);
            Log.i((String)"Tmon", (String)("parseEquation_size : " + elements.size()));
            for (Element e : elements1) {
                String result = TextUtils.isEmpty((CharSequence)parsingOrderRules.attribute) ? e.text() : e.html();
                Log.i((String)"Tmon", (String)("result : " + result));
                results.add(result);
            }
        } else {
            return null;
        }
        return results;
    }

    @Override
    protected String orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.DOT);
    }

    @Override
    protected String orderHmsFilter(@NonNull String orderHms) {
        return orderHms.replace("(", "").replace(")", "");
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {
        try {
            String[] s;
            if (!TextUtils.isEmpty((CharSequence)orderState) && (s = orderState.split("\\|")).length > 1) {
                Log.i((String)"aaa", (String)("info : " + s[0] + "::::" + s.length));
                return s[1].replace(")", "").trim();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

