/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.Mall;

public class ElevenStreet
extends Mall {
    private final String PRODUCT_URL = "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s&xfrom=&xzone=";

    public ElevenStreet(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected String orderDateFilter(@NonNull String orderDate) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderDate)) {
                return orderDate.substring(0, orderDate.indexOf("(") - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty((CharSequence)orderNum) && orderNum.length() > 1) {
                return orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")") - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        int result = 1;
        try {
            if (!TextUtils.isEmpty((CharSequence)quantity)) {
                result = Integer.parseInt(quantity.substring(quantity.indexOf("(") + 1, quantity.indexOf(")")).replace("\uac1c", "").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replaceAll("\uc6d0", "").replaceAll(",", ""));
    }
}

