/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallApiService;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.MallWithUser;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import java.util.List;

public class ScrapServiceImpl
implements ScrapService {
    private final Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager webViewManager;
    private boolean isDoing;
    private String uuid;
    private String serviceAppName;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @Nullable MallApiService api, @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        this.preferences = Injection.provideSharedPreference(context);
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.repository.saveLayer(qualifier);
        this.webViewManager = new WebViewManager(context);
        this.uuid = uuid;
        this.serviceAppName = serviceAppName;
    }

    private void init(String serviceAppName) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            Log.i((String)"UUID", (String)"uuid \uc800\uc7a5 \ubc0f \uc0ac\uc6a9\uc790 \ub4f1\ub85d");
            this.repository.signUpUser(serviceAppName, this.uuid, Void2 -> this.repository.syncRule(callback -> {}));
        }
    }

    @Override
    public WebView getWebView() {
        return this.webViewManager.getWebView();
    }

    @Override
    public void startLoginAndParsing(String userId, String userPwd, int mId, ScrapService.OnResultCallback<List<OrderEntity>> onResult) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userPwd) || mId == 0) {
            throw new ParameterException("empty parameter");
        }
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.logInAndParsing(userId, userPwd, mId, onResult));
        } else {
            this.logInAndParsing(userId, userPwd, mId, onResult);
        }
    }

    private void logInAndParsing(String userId, String userPwd, int mId, final ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (this.isDoing | this.isEnabledSDK()) {
            return;
        }
        this.repository.syncRule(callback -> {
            Log.i((String)"logInAndParsing", (String)"syncRule success");
            this.start(userId, userPwd, mId, new ScrapService.OnResult<List<OrderEntity>>(){

                @Override
                public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                    Log.i((String)"logInAndParsing", (String)("parse success " + mId + msg + itemList));
                    ScrapServiceImpl.this.repository.getOrderList(items -> {
                        Log.i((String)"logInAndParsing", (String)("size" + items.size()));
                        onResult.onDataLoaded(items);
                    }, mId);
                }

                @Override
                public void onFail(int mId, Constants.ERROR error, String msg) {
                    Log.i((String)"logInAndParsing", (String)("error" + error.name() + "onFail" + msg));
                    onResult.onFail(mId, error, msg);
                }
            });
        });
    }

    public void start(final String userId, final String userPwd, final int mId, final ScrapService.OnResult callback) {
        this.repository.checkIsActiveMall(mId, mall -> {
            if (mall == null) {
                return;
            }
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    Log.i((String)"getMallWithUser", (String)("item : " + item));
                    ScrapServiceImpl.this.login(item, 2, callback);
                }

                @Override
                public void onFail() {
                    Log.i((String)"getMallWithUser", (String)("mId : " + mId));
                    ScrapServiceImpl.this.login(new MallWithUser(mall, new UserEntity(mId, userId, userPwd)), 1, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, ScrapService.OnResult onResult) {
        Log.i((String)"login", (String)("MallWithUser : " + mallWithUser));
        this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
            Log.i((String)"login", (String)("loginRule : " + loginRule));
            Mall m = FactoryMall.create(mallWithUser.mall.getDisplayName(), this.repository, this.webViewManager);
            Log.i((String)"login", (String)("Mall : " + m));
            if (m == null) {
                return;
            }
            if (loginRule != null && loginRule.loginWebRule != null) {
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);
            } else {
                onResult.onFail(mallWithUser.mall.getId(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, mallWithUser.mall.getDisplayName() + " login rule does not exist");
            }
        });
    }

    @Override
    public void startParsingMalls(ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        if (!this.preferences.getString("uuid", "").equals(this.uuid)) {
            this.repository.signUpUser(this.serviceAppName, this.uuid, Void2 -> this.getMallsAndParsing(onResult));
        } else {
            this.getMallsAndParsing(onResult);
        }
    }

    private void getMallsAndParsing(final ScrapService.OnResultCallback<List<OrderEntity>> onResult) {
        this.repository.getMallWithUser(items -> {
            Log.i((String)"getMallsAndParsing", (String)("item : " + items));
            for (MallWithUser mallWithUser : items) {
                this.login(mallWithUser, 0, new ScrapService.OnResult<List<OrderEntity>>(){

                    @Override
                    public void onSuccess(int mId, List<OrderEntity> itemList, String msg) {
                        Log.i((String)"onSuccess", (String)("name : " + mId + "size : " + itemList));
                        ScrapServiceImpl.this.repository.getOrderList(items -> {
                            Log.i((String)"DB", (String)("size : " + items.size()));
                            onResult.onDataLoaded(items);
                        }, mId);
                    }

                    @Override
                    public void onFail(int mId, Constants.ERROR error, String msg) {
                    }
                });
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    private boolean isEnabledSDK() {
        return this.preferences.getBoolean("SDK_IS_ENABLE", false);
    }

    @Override
    public void getAllProducts(ScrapService.OnResultCallback<List<OrderEntity>> callback) {
        this.repository.getAllOrderList(callback::onDataLoaded);
    }

    @Override
    public void getMallWithUsers(ScrapService.Callback<List<MallWithUser>> callback) {
        this.repository.getMallWithUser(callback::onDataLoaded);
    }

    @Override
    public void signOut(int mId, ScrapService.OnResultCallback<Void> callback) {
        this.repository.updateUserForSignOut(mId, callback);
    }

    @Override
    public void deleteOrder(int orderId) {
        this.repository.deleteOrder(orderId);
    }

    @Override
    public void deleteOrders(int ... orderIds) {
        this.repository.deleteOrder(orderIds);
    }

    @Override
    public void deleteAll(int ... mIds) {
        if (mIds != null) {
            this.repository.deleteForMallIds(new int[0]);
        } else {
            this.repository.deleteAll();
        }
    }

    @Override
    public void deleteForMallId(int mid) {
        this.repository.deleteForMallId(mid);
    }

    @Override
    public void insertUserEntity(UserEntity userEntity) {
        this.repository.insertUsers(userEntity);
    }
}

