/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.webkit.WebView;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.MallApiService;
import com.tenqube.visual_scraper.ParameterException;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.MallWithUser;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import java.util.List;

public class ScrapServiceImpl
implements ScrapService {
    private final Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager webViewManager;
    private boolean isDoing;
    private String uuid;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @Nullable MallApiService api, @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        this.preferences = Injection.provideSharedPreference(context);
        this.repository = Injection.provideScrapRepository(context.getApplicationContext(), this.preferences);
        this.repository.saveKey(apiKey);
        this.repository.saveLayer(qualifier);
        this.webViewManager = new WebViewManager(context);
        this.uuid = uuid;
        this.init(serviceAppName);
    }

    private void init(String serviceAppName) {
        if (!this.preferences.getString("uuid", "es").equals(this.uuid)) {
            Log.i((String)"UUID", (String)"uuid \uc800\uc7a5 \ubc0f \uc0ac\uc6a9\uc790 \ub4f1\ub85d");
            this.repository.signUpUser(serviceAppName, this.uuid);
        }
    }

    @Override
    public WebView getWebView() {
        return this.webViewManager.getWebView();
    }

    @Override
    public void logInAndParsing(String userId, String userPwd, final int mId, final ScrapService.OnResultCallback<List<OrderEntity>> onResult) throws ParameterException {
        this.repository.syncRule(callback -> {
            Log.i((String)"logInAndParsing", (String)"syncRule success");
            this.start(userId, userPwd, mId, new ScrapService.OnResult(){

                @Override
                public void onSuccess(String mName) {
                    Log.i((String)"logInAndParsing", (String)("parse success" + mName));
                    ScrapServiceImpl.this.repository.getOrderList(items -> {
                        Log.i((String)"logInAndParsing", (String)("size" + items.size()));
                        onResult.onDataLoaded(items);
                    }, mId);
                }

                @Override
                public void onFail(String mName, Constants.ERROR error, String msg) {
                    Log.i((String)"logInAndParsing", (String)("error" + error.name() + "onFail" + msg));
                    onResult.onFail(mName, error, msg);
                }
            });
        });
    }

    public void start(final String userId, final String userPwd, final int mId, final ScrapService.OnResult callback) {
        if (this.isDoing | this.isEnabledSDK()) {
            return;
        }
        this.repository.checkIsActiveMall(mId, mall -> {
            if (mall == null) {
                return;
            }
            this.repository.getMallWithUser(mId, userId, new ScrapService.onResultInterface<MallWithUser>(){

                @Override
                public void onDataLoaded(MallWithUser item) {
                    ScrapServiceImpl.this.login(item, 2, callback);
                }

                @Override
                public void onFail() {
                    ScrapServiceImpl.this.login(new MallWithUser(mall, new UserEntity(mId, userId, userPwd)), 1, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, ScrapService.OnResult onResult) {
        Log.i((String)"login", (String)("MallWithUser : " + mallWithUser));
        this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
            Log.i((String)"login", (String)("loginRule : " + loginRule));
            Mall m = FactoryMall.create(mallWithUser.mall.getDisplayName(), this.repository, this.webViewManager);
            Log.i((String)"login", (String)("Mall : " + m));
            if (m == null) {
                return;
            }
            if (loginRule != null && loginRule.loginWebRule != null) {
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);
            } else {
                onResult.onFail(mallWithUser.mall.getDisplayName(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, "login rule does not exist");
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.preferences.edit().putBoolean("SDK_IS_ENABLE", enabled).apply();
    }

    private boolean isEnabledSDK() {
        return this.preferences.getBoolean("SDK_IS_ENABLE", false);
    }

    @Override
    public void getAllProducts(ScrapService.OnResultCallback<List<OrderEntity>> callback) {
        this.repository.getAllOrderList(callback::onDataLoaded);
    }
}

