package com.tenqube.visual_scraper.scrap.mall;

import android.app.Application;
import android.content.Context;
import android.preference.Preference;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;

import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.LoginRule;
import com.tenqube.visual_scraper.db.entity.newEntity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.view.OrderWebRule;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.login.ApiLogin;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.utils.AppExecutors;
import com.tenqube.visual_scraper.utils.Utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


public class Mall {

    private Context context;
    private AppExecutors appExecutors;

    OrderEntity order;
    OrderWebRule orderWebRule;
    OrderApiRuleJson orderApiRuleJson;
//    RuleEntity rule;
//    private ParsingRuleData parsingRuleData;

    final ScrapRepository repository;
    private final String mName;
    private WebViewManager webViewManager;
//    private Preference preference;

    public Mall(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        this.context = context;
        this.mName = mName;
        this.repository = repository;

        appExecutors = new AppExecutors();
        this.webViewManager = webViewManager;
//        this.preference = Injection.provideSharedPreference()
    }


    public void startWebViewLogin(LoginWebRule loginWebRule, UserEntity user, int crud, @NonNull final ScrapService.OnResult onResult) {
        // 룰에 따른 scripts param 구하기 및 구성
        Utils.getFinalLoginWebRule(loginWebRule, user.getUserId(), user.getUserPwd());

//        appExecutors.mainThread().execute(() -> {
            webViewManager.setWebUrl(loginWebRule.getUrlBody().finalQuery)
                    .setScripts(loginWebRule.getScriptsBody().finalQuery)
                    .setAction(WebViewManager.LOGIN)
                    .build(new WebViewManager.WebViewCallback() {
                        @Override
                        public void onResult(String cookie, WebView webView) {
                            // login success
                            //3. 파싱룰 정보 로드
                            Log.i("startWebViewLogin","login Success : cookie "+cookie+"/"+webView);
                            // user 정보 저장
                            user.setCookie(cookie); // 안해도될것같음
                            user.setLogin(true);
                            repository.insertUsers(user);

                            repository.getOrderWebRule(user.getmId(),(webRule) -> {

                                Log.i("getOrderWebRule","info : "+ webRule);

                                if (webRule != null) {
                                    orderWebRule = webRule;
                                    if (orderWebRule.getUrl() != null) orderWebRule.getUrl().finalQuery = Utils.getOrderValue(orderWebRule.getUrl(), user.getLastScrapAt());
                                    if (orderWebRule.getPeriodScripts() != null) orderWebRule.getPeriodScripts().finalQuery = Utils.getOrderValue(orderWebRule.getPeriodScripts(), user.getLastScrapAt());
                                    Log.i("getOrderWebRule","final_info : "+ orderWebRule);

                                    //4. 파싱
                                    parseWeb(cookie, onResult, items -> {
                                        Log.i("parseWeb","items : "+ items);

                                        //  성공시 데이터 저장
                                        if (items != null && items.size() != 0) {
                                            repository.insertOrders(items);
                                            repository.callInsertOrderList(items);
                                            onResult.onSuccess(mName+" 갯수 : "+items.size());
                                        } else {
                                            onResult.onSuccess(mName+"/구매내역없음");
                                        }
                                    });
                                } else {
                                    onResult.onFail(mName, Constants.ERROR.NOT_FOUND_RULE, "login_web");
                                }
                            });
                        }

                        @Override
                        public void onFail(int statusCode, String statusMessage) {
                            Log.i("login_web","onFail : "+ statusCode +"/"+statusMessage);
                            onResult.onFail(mName, Constants.ERROR.LOGIN_FAIL, statusMessage);
                        }
                    });
//        };

    }

    public void startApiLogin(LoginRule loginRule, UserEntity user, int crud, @NonNull final ScrapService.OnResult onResult) {

        LoginService loginService = new ApiLogin(loginRule.loginApiRule);

        appExecutors.networkIO().execute(() -> loginService.login(new LoginService.OnLoginCallback() {
            @Override
            public void onLoginSuccess(String cookie) {
                // 파싱 룰 가져오기
                repository.getOrderApiRule(user.getmId(), (apiRule) -> {
                    // 파싱

                });
            }

            @Override
            public void onLoginFail(int statusCode, String statusMessage) {
//                onResult.onFail(mName, Constants.ERROR.LOGIN_FAIL, statusMessage);
                // webview login
                startWebViewLogin(loginRule.loginWebRule, user, crud, onResult);
            }
        }));

    }

    private void parseWeb(String cookie, ScrapService.OnResult onResult, ScrapService.Callback<List<OrderEntity>> callback) {

        Runnable runnable = () -> {

            List<OrderEntity> orders = new ArrayList<>();
            try {

                getOrderPageDocument(cookie, orderWebRule, new OrderCallback<Document>() {
                            @Override
                            public void onResult(Document document) {
                                Log.i("parseWeb","onResult "+ document);

                                List<OrderHtml> orderHtmls = convertToOrderHtmlList(document);
                                Log.i("parseWeb","orderHtmls : "+orderHtmls);
                                orders.addAll(convertToOrderEntity(orderHtmls)); //************

                                appExecutors.mainThread().execute(() -> callback.onDataLoaded(orders));
                            }

                            @Override
                            public void onFail(int statusCode, String statusMessage) {
                                appExecutors.mainThread().execute(() -> onResult.onFail(mName, Constants.ERROR.PARSING_FAIL, statusMessage));
                            }
                        }
                        );



            } catch (IOException e) {
                e.printStackTrace();
            }
        };

        appExecutors.networkIO().execute(runnable);

    }

    private List<OrderHtml> convertToOrderHtmlList(Document document) {

        // pave_div, container
        Elements elements = getElements(document, orderWebRule);

        List<OrderHtml> orderHtmls = new ArrayList<>(getOrderHtmls(elements, orderWebRule));


        if (orderHtmls.size() == 0 && !TextUtils.isEmpty(orderWebRule.getContainer().equation)) {
            elements = document.select(orderWebRule.getPageDiv()).select(String.format(orderWebRule.getContainer().selector, "n"));

            orderHtmls.addAll(getOrderHtmls(elements, orderWebRule));
        }

        return orderHtmls;
    }

    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        List<OrderHtml> orderHtmls = new ArrayList<>();

        Log.i("parseWeb","element_size : "+elements.size());
        for (Element element : elements) {
//            Log.i("parseWeb****","element : "+element.text());

            try {
                OrderHtml orderHtml = parseHtml(elements, element);
                Log.i("parseWeb","parsed_orderHtml : "+ orderHtml);
                if (orderHtml != null) orderHtmls.add(orderHtml);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        return orderHtmls;
    }




    private Elements getElements(Document document, OrderWebRule orderWebRule) {
        Elements elements;

        if (TextUtils.isEmpty(orderWebRule.getContainer().equation)) {

            elements = document.select(orderWebRule.getPageDiv()).select(orderWebRule.getContainer().selector);
        } else {

            elements = document.select(orderWebRule.getPageDiv()).select(String.format(orderWebRule.getContainer().selector, orderWebRule.getContainer().equation));
        }

        return elements;
    }



    private List<OrderEntity> convertToOrderEntity(List<OrderHtml> orderHtmls) {

        List<OrderEntity> orders = new ArrayList<>();
        for (OrderHtml orderHtml : orderHtmls) {
            Log.i("filter","orderHtml : "+orderHtml);
            try {
                OrderEntity order = new OrderEntity();
                order.mId = orderWebRule.getMallId();
//                order.uId
                order.title = titleFilter(orderHtml.title); // 필수
                order.orderDate = orderDateFilter(orderHtml.orderDate);
                order.orderHms = orderHmsFilter(orderHtml.orderHms);
                order.orderOption = orderOptionFilter(orderHtml.orderOption);
                order.quantity = quantityFilter(orderHtml.quantity);
                order.price = priceFilter(orderHtml.price);
                order.orderNum = orderNumFilter(orderHtml.orderNum);
                order.orderState = orderStateFilter(orderHtml.orderState);
                order.imgUrl = imgUrlFilter(orderHtml.imgUrl);
                order.currency = "KRW";
//                order. = detailProductLinkFilter(orderHtml.detailProdLink);
                Log.i("filter","info : "+ order);
                orders.add(order);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        return orders;
    }



    /**
     * jsoup 은 자바스크립트코드로 못돌림.
     * 1. jsoup 요청 with cookie
     * @param cookie 쿠키정보
     */
    private void getOrderPageDocument(String cookie, OrderWebRule orderWebRule, OrderCallback<Document> orderCallback /*, Map<String, String> queryParams, int methodType*/) throws IOException {
        try {

            webViewManager.setWebUrl(orderWebRule.getUrl().finalQuery)
                    .setScripts(orderWebRule.getPeriodScripts() == null ? null :orderWebRule.getPeriodScripts().finalQuery)
                    .setAction(WebViewManager.ORDER_PARSING)
                    .build(new WebViewManager.WebViewCallback() {
                        @Override
                        public void onResult(String html, WebView webView) {
//                            Log.i("getOrderPageDocument", "html : " + html);
                            // document 얻기
                            Document document = Jsoup.parse(html);
                            Log.i("getOrderPageDocument", "document : " + document);
                            if (document != null) orderCallback.onResult(document);
                        }

                        @Override
                        public void onFail(int statusCode, String statusMessage) {
                            Log.i("login_web", "onFail : " + statusCode + "/" + statusMessage);
                            orderCallback.onFail(statusCode, statusMessage);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
            orderCallback.onFail(403, "getOrderPageDocument crash");
        }

//        Connection.Response response = Jsoup.connect(url)
//                .userAgent(USER_AGENT)
//                .followRedirects(true)
//                .data(queryParams)
//                .timeout(5000)
//                .ignoreContentType(true)
//                .header("cookie", cookie)
//                .method(methodType == GET ? Connection.Method.GET : Connection.Method.POST)
//                .execute();

//        return response.parse();
    }

    interface OrderCallback<T> {
        void onResult(T document);
        void onFail(int statusCode, String statusMessage);
    }

    protected Document makeDocument(Document document) {

        return document;

    }



    protected OrderHtml parseHtml(Elements elements, @NonNull Element element) {
        OrderHtml order = new OrderHtml();
        order.title = parseValue(element, orderWebRule.getTitle());
        order.orderDate = parseValue(element, orderWebRule.getOrderDate());
        order.orderHms = parseValue(element,orderWebRule.getOrderHms());
        order.orderOption = parseValue(element, orderWebRule.getOrderOption());
        order.quantity = parseValue(element, orderWebRule.getQuantity());
        order.price = parseValue(element, orderWebRule.getPrice());
        order.orderNum = parseValue(element, orderWebRule.getOrderNum());
        order.orderState = parseValue(element, orderWebRule.getOrderState());
        order.imgUrl = parseValue(element, orderWebRule.getImgUrl());
        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink());
        if (TextUtils.isEmpty(order.title) || TextUtils.isEmpty(order.orderDate)
                || TextUtils.isEmpty(order.price) || TextUtils.isEmpty(order.orderNum)) return null;
        return order;
    }



    protected String titleFilter(@NonNull String title) {
        return title;
    }

    protected String orderDateFilter(@NonNull String orderDate) {
        return orderDate;
    }

    protected String orderHmsFilter(@NonNull String orderHms) {
        return orderHms;
    }

    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption;
    }

    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException  {
        return TextUtils.isEmpty(quantity)? 1 : Integer.parseInt(quantity);
    }

    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return TextUtils.isEmpty(price) ? 0 : Double.parseDouble(price.replace(",","").replace("원",""));
    }

    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum;
    }

    protected String orderStateFilter(@NonNull String orderState) {
        return orderState;
    }

    protected String imgUrlFilter(@NonNull String imgUrl) {
        return imgUrl;
    }

    String parseValue(Element element, ParsingOrderRules parsingOrderRules) {
        String key;
        String attr;
        int pos = 0;
        if (parsingOrderRules == null) {
            return "";
        } else {
            key = parsingOrderRules.selector;
            attr = parsingOrderRules.attribute;
        }

        String result = "";
        Log.i("parseValue","key : "+key+"/attr : "+attr);
        try {

            if(!TextUtils.isEmpty(key)) {
                if (key.contains("br")) {
                    key = key.replace("br","b");
                    int classPos = key.indexOf(".");
                    int classPosEnd = key.indexOf(" ", classPos);
                    String classKey = key.substring(classPos, classPosEnd);
                    Element tempValue = element.select(classKey).get(0);/*.get(pos);*/
                    Element replace = Jsoup.parse(tempValue.toString().replace("br","b"));
                    Log.i("parseValue","replace : "+replace);
                    element = replace;
                }

//                if (!TextUtils.isEmpty(parsingOrderRules.equation)) key =
//                Log.i("parseValue1","key : "+key+"/attr : "+attr);
//                Log.i("parseValue1","element : "+element);
//                Log.i("parseValue2","value : "+element.select(key).get(0));

//                if (TextUtils.isEmpty(element.select(key).text())) return "";

                Log.i("parseValue1","element : "+element.select(key));
                Element value = element.select(key).get(0/*pos*/);
                Log.i("parseValue","value : "+value);
                if(TextUtils.isEmpty(attr)) {
                    result = value.text();
                } else {
//                    result = value.html();
                    result = value.attr(attr);
                }
                Log.i("parseValue","result : "+result);
            }
        } catch (Exception e) {
            result = "";
            e.printStackTrace();
        }

        return result;
    }

}
