package com.tenqube.visual_scraper;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.webkit.WebView;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.MallWithUser;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.newEntity.UserEntity;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.FactoryMall;

import java.util.List;

public class ScrapServiceImpl implements ScrapService {

    private final Context context;
    private final String apiKey;
    private final String qualifier;
    ScrapRepository repository;
    private SharedPreferences preferences;
    private WebViewManager webViewManager;

    private boolean isDoing;
    private String uuid;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @Nullable MallApiService api,
                            @NonNull String uuid, @NonNull String serviceAppName) throws ParameterException
    {
        this.context = context;
        this.apiKey = apiKey;
        this.qualifier = qualifier;
        preferences = Injection.provideSharedPreference(context);
        repository = Injection.provideScrapRepository(context.getApplicationContext(), preferences);
        repository.saveKey(apiKey);
        repository.saveLayer(qualifier);
        webViewManager = new WebViewManager(context/*, webView*/);
        this.uuid = uuid;

        init(serviceAppName);
    }

    private void init(String serviceAppName) {
        // uuid 등록
        if (!preferences.getString(Constants.PREF_KEY.UUID, "es").equals(uuid)) {
            Log.i("UUID","uuid 저장 및 사용자 등록");
            repository.signUpUser(serviceAppName, uuid);

        }

        // 룰 동기화
//        repository.syncRule((callback) -> {
//            // 동기화 완료
//
//        });


    }

    @Override
    public WebView getWebView() {
        return webViewManager.getWebView();
    }

    @Override
    public void logInAndParsing(String userId, String userPwd, int mId, OnResultCallback<List<OrderEntity>> onResult) throws ParameterException {
        // 룰 동기화
        repository.syncRule((callback) -> {
            // 동기화 완료
            Log.i("logInAndParsing", "syncRule success");

            start(userId, userPwd, mId, new OnResult() {
                @Override
                public void onSuccess(String mName) {
                    Log.i("logInAndParsing", "parse success"+mName);


                    repository.getOrderList(items -> {
                        Log.i("logInAndParsing", "size" + items.size());

                        onResult.onDataLoaded(items);

                    }, mId);
                }

                @Override
                public void onFail(String mName, Constants.ERROR error, String msg) {
                    Log.i("logInAndParsing", "error" + error.name() + "onFail" + msg);
                    onResult.onFail(mName, error, msg);
                }
            });
        });
    }

    //onResult -> 따로.. -> 받아서 lastScrapDate 동기화
//    @Override
    public void start(String userId, String userPwd, int mId, OnResult callback) {
        // sdk 활성화 여부 체크
        if(isDoing | isEnabledSDK())
            return;

        // 몰 활성화 여부 조회
        repository.checkIsActiveMall(mId, (mall) -> {
            // mall Active 하지 않거나, 해당 몰정보 없음
            if (mall == null) return;

            // 유저 (& 몰정보) 가져오기
            repository.getMallWithUser(mId, userId, new onResultInterface<MallWithUser>() {
                @Override
                public void onDataLoaded(MallWithUser item) {
                    // 유저 정보 존재 -> 로그인 성공시 비번 다를경우, 업데이트
                    // login
                    login(item, Constants.CRUD.UPDATE, callback);
                }

                @Override
                public void onFail() {
                    // 유저 및 몰정보 없음 -> 해당 mall 의 신규 user id 등록
                    login(new MallWithUser(mall, new UserEntity(mId, userId, userPwd)), Constants.CRUD.INSERT, callback);
                }
            });
        });
    }

    private void login(MallWithUser mallWithUser, int crud, OnResult onResult) {
        Log.i("login","MallWithUser : "+mallWithUser);
        // login rule 가져오기
        repository.getLoginRule(mallWithUser.mall.getId(), (loginRule) -> {
            Log.i("login","loginRule : "+loginRule);

            com.tenqube.visual_scraper.scrap.mall.Mall m = FactoryMall.create(mallWithUser.mall.getDisplayName(), repository, webViewManager);
            Log.i("login","Mall : "+m);
            if (m == null) return;

//            isDoing = true;
            /*if (loginRule != null && loginRule.loginApiRule != null) {
                // api login
                m.startApiLogin(loginRule, mallWithUser.user, crud, onResult);

            } else*/ if (loginRule != null && loginRule.loginWebRule != null) {
                // web login
                m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, crud, onResult);

            } else {
                // login rule 정보 없음
                onResult.onFail(mallWithUser.mall.getDisplayName(), Constants.ERROR.NOT_FOUND_LOGIN_RULE, "login rule does not exist");
            }
        });
    }


//    @Override
//    public void start(OnResult onResult) throws ParameterException {
//
//    }

    @Override
    public void setEnabled(boolean enabled) {
        preferences.edit().putBoolean(Constants.PREF_KEY.SDK_IS_ENABLE, enabled).apply();
    }

    private boolean isEnabledSDK() {
        return preferences.getBoolean(Constants.PREF_KEY.SDK_IS_ENABLE, false);
    }

    @Override
    public void getAllProducts(OnResultCallback<List<OrderEntity>> callback) {
        repository.getAllOrderList((callback::onDataLoaded));
    }



//
//    @Override
//    public void getMalls(Callback<List<Mall_temp>> callback) {
//        if (isEnabledSDK()) return;
//
//
//    }
//
//    @Override
//    public void getOrders(Callback<List<OrderEntity>> callback, int... mIds) {
//        if (isEnabledSDK()) return;
//
//        // uuid 로 조회
//
//
//        // 파싱 & 저장
////        start();
//
//        // 몰리스트 조회
//
//    }
//
//    @Override
//    public void deleteAll(int... mIds) {
//
//    }
//
//    @Override
//    public void exportCSV(Callback<File> callback, int... mIds) {
//
//    }
//
//    @Override
//    public void signOut(int mId) {
//
//    }
//
//    @Override
//    public void deleteOrder(int orderId) {
//
//    }
//
//
//    @Override
//    public void updateOrder(OrderEntity order) {
//
//    }


//    @Override
//    public void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls) {
//
//    }
//
//    @Override
//    public void exportCSV() {
//
//    }

    //    /**
//     * 이미 저장된 사용자 정보를 통해 로그인 처리
//     * @param mall 몰정보
//     * @param onResult
//     */
//    @Override
//    public void start(Constants.MALL mall, OnResult onResult) {
//        if(isDoing)
//            return;
//
//            repository.getUser(mall, user -> {
//
//                if(user == null) {
//                    onResult.onFail(mall, LOGIN_FAIL, "사용자 없음 ");
//                    return;
//                }
//
//                com.tenqube.visual_scraper.scrap.mall.Mall_temp m = FactoryMall.create(mall, repository);
//                if(m != null) {
//                    isDoing = true;
//                    m.start(context, user, onResult);
//                } else {
//                    onResult.onFail(mall, Constants.ERROR.NOT_FOUND_MALL, "몰 없음 ");
//                }
//        });
//    }

//    @Override
//    public void signOut(Constants.MALL mall) {
//        repository.deleteUser(mall);
//    }
//
//    @Override
//    public void getMalls(Callback<List<Mall_temp>> callback) {
//        repository.getMalls(callback);
//    }
//
//    @Override
//    public void getAllProducts(Callback<List<OrderEntity>> callback) {
//        repository.getAllOrders(callback);
//    }
//
//    @Override
//    public void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls) {
//
//    }
//
//    @Override
//    public void exportCSV() throws SecurityException {
//        String[] perms = {Manifest.permission.WRITE_EXTERNAL_STORAGE};
//
//        if (Utils.hasPermissions(context, perms)) {
//
//            repository.getAllOrders(CSVHelper::export);
//
//        } else {
//            throw new SecurityException();
//        }
//
//    }
}
