package com.tenqube.visual_scraper;

import android.webkit.WebView;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.newEntity.OrderEntity;
import com.tenqube.visual_scraper.model.Mall_temp;
import com.tenqube.visual_scraper.model.api.Order;

import java.io.File;
import java.util.List;

public interface ScrapService {

    WebView getWebView();
//    /**
//     * 사용자 등록
//     * - 사용자 등록 및 요청 url 정보 수신
//     * @param uuid
//     * @throws ParameterException
//     */
//    void register(String uuid) throws ParameterException;


    void logInAndParsing(String userId, String userPwd, int mId, OnResultCallback<List<OrderEntity>> onResult) throws ParameterException;

    /**
     * 몰파싱
     * - 스크래핑 시작하기 로그인 정보 포함
     * @param userId 사용자 아이디
     * @param userPwd 사용자 패스워드
     * @param mId 온라인 몰 종류
     * @param onResult 몰 파싱 여부
     */
//    void start(String userId, String userPwd, int mId, OnResult onResult);

//    /**
//     * 로그인 활성화 된 몰 파싱
//     * - 스크래핑 시작하기 이미 로그인정보 존재하는 경우
//     * @param onResult result 값 하나씩 콜백받아서 -> 몰 단위로 파싱해오기 (intent Service))
//     */
//    void start(OnResult onResult) throws ParameterException;

    /**
     * SDK 작동 설정
     * - SDK 사용 여부 설정
     * @param enabled
     */
    void setEnabled(boolean enabled);

//    /**
//     * 몰정보 조회
//     * - 파싱된 몰 정보 가져오기
//     * @param callback
//     */
//    void getMalls(Callback<List<Mall_temp>> callback);
//
//    /**
//     * 주문 내역 조회
//     * - malls == null : 전체
//     * @param callback
//     * @param mIds mall_ids
//     */
//    void getOrders(Callback<List<OrderEntity>> callback, int... mIds);
//
//    /**
//     * 내역 단건 삭제
//     * - 주문 id에 맞는 주문 삭제
//     * @param orderId
//     */
//    void deleteOrder(int orderId);
//
//    /**
//     * 몰 정보에 따른 내역 삭제
//     * - malls == null 전체 모든 파싱 내역 초기화
//     * @param mIds
//     */
//    void deleteAll(int... mIds);
//
//    /**
//     * 내역 csv 추출
//     * - malls == null 전체 추출
//     * @param callback
//     * @param mIds
//     */
//    void exportCSV(Callback<File> callback, int... mIds);
//
//    /**
//     * 내역 편집
//     * @param order
//     */
//    void updateOrder(OrderEntity order);
//
//    /**
//     * 로그아웃
//     * - 해당 몰에 활성화 중인 계정, isActive false 처리하기
//     * @param mId
//     */
//    void signOut(int mId);








        /**
         *  스크랩핑된 모든 제품 정보 받기
         */
    void getAllProducts(OnResultCallback<List<OrderEntity>> callback);

//    /**
//     * 특정 몰에 따른 제품 정보 받기
//     * @param malls
//     */
//    void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls);
//
//    /**
//     * 전체 상품 목록 CSV로 추출
//     */
//    void exportCSV();

    interface Callback<T> {
        void onDataLoaded(T items);
    }

    interface onResultInterface<T> {
        void onDataLoaded(T item);

        void onFail();
    }

    interface OnResultCallback<T> {
        void onDataLoaded(T item);

        void onFail(String mName, Constants.ERROR error, String msg);
    }

    interface OnResult {

        void onSuccess(String mName);

        void onFail(String mName, Constants.ERROR error, String msg);

    }
}
