package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import com.tenqube.visual_scraper.vo.api.RequestContentData;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;

import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

import static com.tenqube.visual_scraper.constants.Constants.METHOD_TYPE.GET;
import static com.tenqube.visual_scraper.constants.Constants.USER_AGENT;

public class MallParser implements Parser {

    public static final String TAG = MallParser.class.getSimpleName();

    @NonNull
    private ParsingRuleData mParsingRuleData;

    public MallParser(@NonNull ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
    }

    @Override
    public void parse(String cookie, OnResponsePurchasePage mListener) {

        try {

            Connection.Response response = requestUrl(
                    mParsingRuleData.getPurchaseUrl(),
                    cookie, mParsingRuleData.getScrap().getPurchaseMethodType(),
                    Objects.requireNonNull(mParsingRuleData.getPurchaseParams()));

            RequestDocumentData requestDocumentData = parseResponse(response);

            mListener.onPurchasePageResult(requestDocumentData);

        } catch (Exception e) {
            e.printStackTrace();
            mListener.onParsingFail(e.toString());
        }
    }

    private Connection.Response requestUrl(String url, String cookie, int methodType, @NonNull Map<String, String> queryParams) throws Exception {

        return Jsoup.connect(url)
                .userAgent(USER_AGENT)
                .followRedirects(true)
                .data(queryParams)
                .timeout(26000)
                .ignoreContentType(true)
                .header("cookie", cookie)
                .method(methodType == GET ? Connection.Method.GET : Connection.Method.POST)
                .execute();
    }

    private RequestDocumentData parseResponse(@NonNull Connection.Response response) throws Exception {

        Document doc = response.parse();

        RequestDocumentData requestDocumentData = new RequestDocumentData();
        requestDocumentData.contents = new ArrayList<>();

        RequestContentData requestData = new RequestContentData();
        if (response.contentType().contains(Constants.CONTENT_TYPE.JSON_KEY)) {
            requestData.contentType = Constants.CONTENT_TYPE.JSON;
            requestData.content = doc.select("body").html();
        } else {
            requestData.contentType = Constants.CONTENT_TYPE.URL_ENCODED;
            requestData.content = doc.select(Objects.requireNonNull(mParsingRuleData.getScrap().getPurchasePageDivCss())).outerHtml();
        }

        requestDocumentData.contents.add(requestData);
        requestDocumentData.name = mParsingRuleData.getScrap().getName();
        requestDocumentData.parsingType = Constants.SCRAP_TYPE.PURCHASE;

        return requestDocumentData;
    }

}
