/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.Mall;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gmarket
extends Mall {
    public Gmarket(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty((CharSequence)orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10) : "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        Pattern pattern;
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)quantity) && (matcher = (pattern = Pattern.compile("\\s*\uc218\ub7c9\\s*:\\s*(\\d+)\uac1c\\s*/\\s*\uc8fc\ubb38\ubc88\ud638\\s*:\\s*\\S+\\s*", 34)).matcher(quantity.charAt(0) + "")).matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 1;
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        Pattern pattern;
        Matcher matcher;
        if (!TextUtils.isEmpty((CharSequence)orderNum) && (matcher = (pattern = Pattern.compile("\\s*\uc8fc\ubb38\ubc88\ud638\\s*(\\S+)\\s*", 34)).matcher(orderNum)).matches()) {
            return matcher.group(1);
        }
        return "";
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        return super.imgUrlFilter(imgUrl);
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        return super.checkLoginPageOrNot(url);
    }
}

