package com.tenqube.visual_scraper.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;

import com.google.gson.Gson;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.model.jsonParsing.ValueRules;
import com.tenqube.visual_scraper.model.view.OrderInfo;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;


public class Utils {

    public static boolean hasPermissions(@NonNull Context context, @NonNull String... perms) {
        // Always return true for SDK < M, let the system deal with the permissions
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            // DANGER ZONE!!! Changing this will break the library.
            return true;
        }

        for (String perm : perms) {
            boolean hasPerm = (ContextCompat.checkSelfPermission(context, perm) ==
                    PackageManager.PERMISSION_GRANTED);
            if (!hasPerm) {
                return false;
            }
        }

        return true;
    }

//    public static String getDeviceId(Context context) {
//        try {
//
//            AdvertisingIdClient.Info info = getAdvertisingIdInfo(context);
//            if(info != null && !info.isLimitAdTrackingEnabled()) {
//                return info.getId();
//            } else {
//                return getAndroidId(context);
//            }
//
//        } catch (Exception e) {
//            return getAndroidId(context);
//        }
//
//    }

    private static String getAndroidId(Context context) {
        try {

            @SuppressLint("HardwareIds")
            String androidDeviceId = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
            return androidDeviceId;

        } catch (Exception e) {
            return "";
        }
    }

    public static void getFinalLoginWebRule(LoginWebRule loginWebRule, String userId, String password) {

        QueryRuleBody urlBody = loginWebRule.getUrlBody();
        QueryRuleBody scriptsBody = loginWebRule.getScriptsBody();

        List<Object> param;

        // url
        if (urlBody.values == null) {
            loginWebRule.getUrlBody().finalQuery = urlBody.query;
        } else {
            param = Utils.getLoginParam(urlBody, userId, password);
            Log.i("getFinalLoginWebRule","param : "+param + "/"+urlBody.query);
            String finalStr = String.format(urlBody.query, param.toArray());
            Log.i("login","webview : "+finalStr);
            loginWebRule.getUrlBody().finalQuery = finalStr;
        }

        // loginScripts
        if (scriptsBody.values == null) {
            loginWebRule.getScriptsBody().finalQuery = scriptsBody.query;
        } else {
            param = Utils.getLoginParam(scriptsBody, userId, password);
            Log.i("getFinalLoginWebRule","param : "+param + "/"+scriptsBody.query);

            String finalStr = String.format(scriptsBody.query, param.toArray());
            Log.i("getFinalLoginWebRule","webview : "+finalStr);
            loginWebRule.getScriptsBody().finalQuery = finalStr;
        }

        Log.i("final","loginWebRule : "+loginWebRule);

    }

    public static List<Object> getLoginParam(QueryRuleBody queryRuleBody, String userId, String password) {
        List<Object> strArray = new ArrayList<>();

        if (queryRuleBody.values != null) {
            for(ValueRules v : queryRuleBody.values) {
                if (v.rule.equals("id")) {
                    strArray.add(userId);
                } else if(v.rule.equals("pw")) {
                    strArray.add(password);
                }
            }
        }
        return strArray;
    }

    public static String getOrderValue (QueryRuleBody queryRuleBody, long lastScrapAt) {
        return queryRuleBody.values != null ?String.format(queryRuleBody.query, getOrderParam(queryRuleBody, lastScrapAt).toArray()) : queryRuleBody.query;
    }


    public static ArrayList<Object> getOrderParam(QueryRuleBody queryRuleBody, long lastScrapAt) {
        ArrayList<Object> param = new ArrayList<>();

        for (ValueRules v : queryRuleBody.values) {

            if (v.rule.equals("date")) {
                String s = DateUtils.getDateFormat(v.format, v.range, lastScrapAt);
                Log.i("date", "s : "+ s);
                param.add(s);

            } else if (v.rule.equals("choice")) {
                String[] s= v.option.split("/");
                Log.i("choice", "s : "+ s[0]);
                param.add(s[0]);
            }
        }

        return param;
    }

    public static long getLastScrapAt() {
        return new Date().getTime(); //DateUtils.getDateFormat(DateUtils.LAST_SCRAPT_AT_FORMAT, "0M", 0);
    }


    public static <T> T parseJsonObject(String input, Class<T> tClass) {
        return TextUtils.isEmpty(input) ? null : Utils.fromJson(input, tClass);
    }

    public static  <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return gson.fromJson(param, classOfT);
    }

    public static  <T> T fromJson(Reader param, Class<T> classOfT) {
        Gson gson = new Gson();
        return gson.fromJson(param, classOfT);
    }

//    public static JsonObject fromJson(String param, JsonObject jsonObject) {
//        Gson gson = new Gson();
//        return gson.fromJson(param, jsonObject);
//    }

    public static String toJson(Object object) {

        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static String loadJSONFromAsset(@NonNull Context context, String fileName) {
        String json = null;
        try {
            AssetManager am = context.getAssets();
            InputStream is = am.open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        } catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public static int calculateEquation(String equation) {
        int result = 0;
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("rhino");

            result = new BigDecimal(engine.eval(equation).toString()).intValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Log.i("calculateEquation","result :" + result);
        return result;
    }

    public static List<OrderInfo> convertOrderInfo(List<OrderEntity> list) {
        List<OrderInfo> results = new ArrayList<>();

        for (OrderEntity orderEntity : list) {
            results.add(new OrderInfo(orderEntity._id,orderEntity.mId,orderEntity.uId,orderEntity.title,
                    orderEntity.orderDate,orderEntity.orderHms,orderEntity.orderOption,orderEntity.quantity,
                    orderEntity.price,orderEntity.currency,orderEntity.orderNum,orderEntity.orderState,
                    orderEntity.imgUrl,orderEntity.detailOrderLink,orderEntity.detailProductLink));
        }

        return results;
    }

}
