/*
 * Copyright 2017, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.tenqube.visual_scraper.db.entity.OrderEntity;

import java.util.List;


@Dao
public interface OrderDao {

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    long insert(OrderEntity product);

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    List<Long> insertList(List<OrderEntity> product);

    @Query( "SELECT * " +
            "FROM orders " +
            "WHERE is_delete = 0 " +
            "ORDER BY order_date DESC")
    List<OrderEntity> getOrders();

    @Query( "SELECT * " +
            "FROM orders WHERE mall_id IN (:mIds) AND is_delete = 0 " +
            "ORDER BY mall_id, order_date DESC")
    List<OrderEntity> getOrders(int...mIds);

    @Query("SELECT * " +
            "FROM orders WHERE mall_id = :mId AND is_delete = 0 " +
            "ORDER BY order_date DESC ")
    List<OrderEntity> getOrders(int mId);

    @Query("DELETE FROM orders WHERE _id = :orderId")
    void deleteOrder(int orderId);

    @Query("DELETE FROM orders WHERE _id IN (:orderId)")
    void deleteOrders(int... orderId);

    @Query("DELETE FROM orders WHERE mall_id = :mallId")
    void deleteOrdersForMallId(int mallId);

    @Query("DELETE FROM orders WHERE _id IN (:mallIds)")
    void deleteOrderForMallIds(int... mallIds);

    @Query("DELETE FROM orders")
    void deleteAll();

//    @Query("SELECT * " +
//            "FROM orders WHERE mall_name IN (:malls)")
//    List<OrderEntity> getOrders(List<String> malls);

}
