package com.tenqube.visual_scraper;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.vo.Mall;

import java.util.List;

public interface ScrapService {

    /**
     * 스크래핑 시작하기 로그인 정보 포함
     * @param userId 사용자 아이디
     * @param userPw 사용자 패스워드
     * @param mall 몰정보
     */
    void start(String userId, String userPw, Constants.MALL mall, OnResult onResult);

    /**
     * 스크래핑 시작하기 이미 로그인정보 존재하는 경우
     * @param mall 몰정보
     */
    void start(Constants.MALL mall, OnResult onResult);

    void signOut(Constants.MALL mall);

    void getMalls(Callback<List<Mall>> callback);

    /**
     *  스크랩핑된 모든 제품 정보 받기
     */
    void getAllProducts(Callback<List<OrderEntity>> callback);

    /**
     * 특정 몰에 따른 제품 정보 받기
     * @param malls
     */
    void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls);

    /**
     * 전체 상품 목록 CSV로 추출
     */
    void exportCSV();

    interface Callback<T> {
        void onDataLoaded(T items);
    }

    interface OnResult {

        void onSuccess(Constants.MALL mall);

        void onFail(Constants.MALL mall, Constants.ERROR error, String msg);

    }
}
