package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;

import org.jsoup.nodes.Element;

public class Wemake extends Mall {

    String URL = "http://www.wemakeprice.com";

    public Wemake(String mName, ScrapRepository repository, WebViewManager webViewManager) {
        super(mName, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null);
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
////        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink(), 0, "href");
//
//        return order;
//    }

    @Override
    protected String orderDateFilter(@NonNull String orderDate) {
        return !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10) : "";
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption
                .replace("\t", "")
                .replace("\n", "");
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {
        return !TextUtils.isEmpty(orderState) && orderState.length() > 3 ? orderState.substring(0, 4) : "";
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty(orderNum) && orderNum.length() > 1) {
                return orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}
