package com.tenqube.visual_scraper.utils;

import android.util.Log;

import com.tenqube.visual_scraper.scrap.Scraper;

/**
 * Created by tenqube on 2018. 4. 30..
 */


public class LogUtil {
    private static final String LOG_PREFIX = "scraper_log";
    private static final int LOG_PREFIX_LENGTH = LOG_PREFIX.length();
    private static final int MAX_LOG_TAG_LENGTH = 23;

    public static String makeLogTag(String str) {
        if (str.length() > MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH) {
            return LOG_PREFIX + str.substring(0, MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH - 1);
        }

        return LOG_PREFIX + str;
    }

    public static String makeLogTag(Class cls) {
        return makeLogTag(cls.getSimpleName());
    }

    public static void LOGI(final String tag, String message) {
        if (Scraper.SCRAPING_DEBUG_MODE) {
            String temp= message;
            while( temp.length() > 4000 ) {
                if( temp.length() > 4000 ) {
                    Log.i(tag, temp.substring( 0, 4000 ));
                    temp = temp.substring( 4000 );
                }
            }
            Log.i(tag, temp);

        }
    }



    private LogUtil() {
    }
}