package com.tenqube.visual_scraper.scrap.login;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.vo.ParsingRuleData;

import java.util.Timer;
import java.util.TimerTask;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

public class WebViewLogin implements LoginService {

    private OnLoginCallback callback;
    private ParsingRuleData mParsingRuleData;
//    private ViewGroup viewGroup;
    private Handler handler;
    private WebView webView;
//    private View webViewLayout;
    private boolean usedLoginScript;
    private boolean isLoginSuccess;
    private static final long TiMEOUT_TIMEMILLIS = 10000;
    private Timer timer;
    private TimerTask timerTask;
    private Handler mTimerHandler = new Handler();
    private Context mContext;
    private static final String TAG = LogUtil.makeLogTag(WebViewLogin.class);
    private CookieManager cookieManager;

    @SuppressLint({"AddJavascriptInterface", "SetJavaScriptEnabled"})
    public WebViewLogin(Context context, ParsingRuleData parsingRuleData) {
        mParsingRuleData = parsingRuleData;
        mContext = context;
        this.handler = new Handler();
        init(mContext);
    }

    private void init(final Context context) {

        webView = new WebView(context);
        cookieManager = createCookieManager();

        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT);
        webView.setWebViewClient(new WebViewClient() {

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                stopTimer();
                closeWebView();
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    callback.onLoginFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    callback.onLoginFail(403, error.toString());
                }
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);

                try {
                    stopTimer();
                    // 로그인 처리 완료
                    if(checkLoginState(url)) return;

                    if (!usedLoginScript) { //로그인 스크립트 실행

                        loadUrl(mParsingRuleData.getWebViewScriptCode());
                        usedLoginScript = true;

                    } else { //로그인 스크립트 초기화 플래그
                        usedLoginScript = false;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    closeWebView();
                    callback.onLoginFail(403, e.toString());
                }
            }

        });
    }


    private boolean checkLoginState(String url) {
        if (usedLoginScript &&
                cookieManager.getCookie(url) != null
//                        &&
//                        (mParsingRuleData.getExceptScriptCode() == null ||
//                                mParsingRuleData.getExceptScriptCode().size() == 0)
                ) {

            isLoginSuccess = isLoginSuccess(cookieManager.getCookie(url));
            closeWebView();

            if(isLoginSuccess) {
                callback.onLoginSuccess(cookieManager.getCookie(url));
            } else {
                callback.onLoginFail(403, Constants.MESSAGES.INVALID_USER_INFO);
            }
            return true;
        }

        return false;
    }

    private void loadUrl(String url) {
        startTimer();
        handler.post(() -> webView.loadUrl(url, null));

    }

    private CookieManager createCookieManager() {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);

        CookieSyncManager.createInstance(mContext);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            webView.getSettings().setSafeBrowsingEnabled(false);
        }
        return cookieManager;
    }

    @Override
    public void login(LoginService.OnLoginCallback callback) {
        this.callback = callback;
        loadUrl(mParsingRuleData.getScrap().getLoginUrl());
    }

    private void closeWebView() {
        if (webView != null) {
            handler.post(() -> {
                webView.stopLoading();
                webView.clearCache(true);
                webView.clearHistory();

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    cookieManager.removeSessionCookies(value -> {
                    });
                } else {
                    cookieManager.removeSessionCookie();
                }
                cookieManager.removeAllCookie();
            });
        }
    }

    private boolean isLoginSuccess(final String cookie) {
        LOGI(TAG, cookie);
        if(mParsingRuleData.getValidCookieKey() != null) {

            for (String invalidKey : mParsingRuleData.getValidCookieKey()) {
                if (!cookie.contains(invalidKey)) {
                    return false;
                }
            }
        }
        return true;
    }
    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    private void startTimer(){

        timer = new Timer();
        timerTask = new TimerTask() {
            public void run() {
                mTimerHandler.post(() -> {

                    stopTimer();

                    if(mParsingRuleData.getExceptScriptCode() != null && mParsingRuleData.getExceptScriptCode().size() > 0) {   //예외화면 스크립트 실행

                        loadUrl(mParsingRuleData.getExceptScriptCode().get(0));

                        mParsingRuleData.getExceptScriptCode().remove(0);

                    } else {
                        closeWebView();
                        usedLoginScript = false;
                        callback.onLoginFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                    }


                });
            }
        };

        timer.schedule(timerTask, TiMEOUT_TIMEMILLIS);
    }


}
