/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.ScrapEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.OnPurchaseResult;
import com.tenqube.visual_scraper.scrap.Scraper;
import com.tenqube.visual_scraper.utils.CSVHelper;
import com.tenqube.visual_scraper.utils.Utils;
import com.tenqube.visual_scraper.vo.Mall;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import com.tenqube.visual_scraper.vo.api.RequestDocumentData;
import java.util.List;

public class ScrapServiceImpl
implements ScrapService {
    private final Context context;
    private final String apiKey;
    private final String layer;
    ScrapRepository repository;
    Scraper scraper;
    private boolean isDoing;

    public ScrapServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String layer) {
        this.context = context;
        this.apiKey = apiKey;
        this.layer = layer;
        this.repository = Injection.provideScrapRepository(context.getApplicationContext());
        this.repository.saveKey(apiKey);
        this.repository.saveLayer(layer);
    }

    @Override
    public void start(String userId, String userPw, Constants.MALL mall, ScrapService.OnResult onResult) {
        if (this.isDoing) {
            return;
        }
        this.repository.syncRule(items -> this.repository.getUser(userId, userPw, mall, user -> {
            if (user == null) {
                onResult.onFail(mall, Constants.ERROR.LOGIN_FAIL, "\uc0ac\uc6a9\uc790 \uc5c6\uc74c ");
                return;
            }
            this.start(mall, (UserEntity)user, onResult);
        }));
    }

    @Override
    public void start(Constants.MALL mall, ScrapService.OnResult onResult) {
        if (this.isDoing) {
            return;
        }
        this.repository.syncRule(items -> this.repository.getUser(mall, user -> {
            if (user == null) {
                onResult.onFail(mall, Constants.ERROR.LOGIN_FAIL, "\uc0ac\uc6a9\uc790 \uc5c6\uc74c ");
                return;
            }
            this.start(mall, (UserEntity)user, onResult);
        }));
    }

    @Override
    public void signOut(Constants.MALL mall) {
        this.repository.deleteUser(mall);
    }

    @Override
    public void getMalls(ScrapService.Callback<List<Mall>> callback) {
        this.repository.syncRule(items -> this.repository.getMalls(callback));
    }

    private void start(final @NonNull Constants.MALL mall, final @NonNull UserEntity userEntity, final @NonNull ScrapService.OnResult onResult) {
        this.isDoing = true;
        this.repository.geScrapRule(mall, scrap -> {
            if (scrap == null) {
                onResult.onFail(mall, Constants.ERROR.NOT_FOUND_MALL, "\ubab0\uc815\ubcf4 \uc5c6\uc74c");
                return;
            }
            ParsingRuleData parsingRuleData = new ParsingRuleData((ScrapEntity)scrap, userEntity);
            this.scraper = new Scraper(this.context, parsingRuleData, new OnPurchaseResult(){

                @Override
                public void onLoginFail(int statusCode, String errorMessage) {
                    ScrapServiceImpl.this.isDoing = false;
                    ScrapServiceImpl.this.repository.deleteUser(userEntity);
                    onResult.onFail(mall, Constants.ERROR.LOGIN_FAIL, errorMessage);
                }

                @Override
                public void onPurchaseFinished(String statusMessage, RequestDocumentData purchaseHtml) {
                    ScrapServiceImpl.this.isDoing = false;
                    ScrapServiceImpl.this.repository.requestMallParsing(userEntity.getId(), purchaseHtml, items -> onResult.onSuccess(mall));
                }

                @Override
                public void onFail(int statusCode, String errorMessage) {
                    ScrapServiceImpl.this.isDoing = false;
                    onResult.onFail(mall, Constants.ERROR.PARSING, errorMessage);
                }
            }, true);
            this.scraper.start();
        });
    }

    @Override
    public void getAllProducts(ScrapService.Callback<List<OrderEntity>> callback) {
        this.repository.getAllOrders(callback);
    }

    @Override
    public void getProducts(ScrapService.Callback<List<OrderEntity>> callback, Constants.MALL ... malls) {
    }

    @Override
    public void exportCSV() throws SecurityException {
        String[] perms = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        if (!Utils.hasPermissions(this.context, perms)) {
            throw new SecurityException();
        }
        this.repository.getAllOrders(CSVHelper::export);
    }
}

