package com.tenqube.visual_scraper.vo.api;

import com.google.gson.Gson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;

import java.io.Serializable;

/**
 * Created by tenqube on 2018. 6. 1..cw.jeon
 */

public class Order implements Serializable {

    public String title;
    public String orderDate;
    public String orderHms;
    public String orderOption;
    public int quantity;
    public int price;
    public String orderNum;
    public String orderState;
    public String imgUrl;
    public DetailOrder detailOrder;
    public String detailProdLink;

    public static class DetailOrder implements Serializable {

        public String link;
        public String params;
        public int methodType;

        @Override
        public String toString() {
            return "DetailOrder{" +
                    "link='" + link + '\'' +
                    ", params=" + params +
                    ", methodType=" + methodType +
                    '}';
        }

        public String toJson() {
            Gson gson = new Gson();
            return gson.toJson(this);
        }
    }

    @Override
    public String toString() {
        return "Order{" +
                "title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity=" + quantity +
                ", price=" + price +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", detailOrder=" + detailOrder +
                ", detailProdLink='" + detailProdLink + '\'' +
                '}';
    }

    public OrderEntity toEntity(int uid) {

        String jsonDetailOrder = detailOrder == null? "" : detailOrder.toJson();
        return new OrderEntity(0, uid, title, orderDate, orderHms, orderOption, quantity, price, orderNum, orderState, imgUrl, jsonDetailOrder, detailProdLink);
    }
}
