/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.scrap.login;

import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.scrap.login.LoginService;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.utils.Validator;
import com.tenqube.visual_scraper.vo.ParsingRuleData;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ApiLogin
implements LoginService {
    private ParsingRuleData mParsingRuleData;
    private static final String TAG = LogUtil.makeLogTag(ApiLogin.class);

    public ApiLogin(ParsingRuleData parsingRuleData) {
        this.mParsingRuleData = parsingRuleData;
    }

    @Override
    public void login(@NonNull LoginService.OnLoginCallback callback) {
        try {
            Connection.Response response = Jsoup.connect((String)this.mParsingRuleData.getScrap().getLoginUrl()).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).timeout(6000).ignoreContentType(true).data(this.mParsingRuleData.getLoginParams()).method(Connection.Method.POST).execute();
            Map cookies = response.cookies();
            if (this.isValidCookie(cookies)) {
                String cookie = Validator.convertMaptoString(response.cookies());
                callback.onLoginSuccess(cookie);
            } else {
                callback.onLoginFail(response.statusCode(), "Invalid User Info");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.onLoginFail(0, e.toString());
        }
    }

    private boolean isValidCookie(Map<String, String> cookies) {
        if (this.mParsingRuleData.getValidCookieKey() != null) {
            for (String invalidKey : this.mParsingRuleData.getValidCookieKey()) {
                if (cookies.containsKey(invalidKey)) continue;
                return false;
            }
        }
        return true;
    }
}

