/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.entity.UserEntity;

public class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteUser;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `users`(`_id`,`mall_name`,`uid`,`pwd`,`last_scrap_at`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMallName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMallName());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getPassword() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPassword());
                }
                if (value.getLastScrapAt() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getLastScrapAt());
                }
            }
        };
        this.__preparedStmtOfDeleteUser = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE  FROM users WHERE _id = ?";
                return "DELETE  FROM users WHERE _id = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(UserEntity user) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfUserEntity.insertAndReturnId((Object)user);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(int id) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteUser.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            _stmt.bindLong(_argIndex, (long)id);
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteUser.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserEntity getUser(String uid, String pwd, String mall) {
        String _sql = "SELECT * FROM users WHERE uid  = ? and pwd = ? and mall_name = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users WHERE uid  = ? and pwd = ? and mall_name = ?", (int)3);
        int _argIndex = 1;
        if (uid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uid);
        }
        _argIndex = 2;
        if (pwd == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pwd);
        }
        _argIndex = 3;
        if (mall == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, mall);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            UserEntity _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfMMallName = _cursor.getColumnIndexOrThrow("mall_name");
            int _cursorIndexOfMUserId = _cursor.getColumnIndexOrThrow("uid");
            int _cursorIndexOfMPassword = _cursor.getColumnIndexOrThrow("pwd");
            int _cursorIndexOfMLastScrapAt = _cursor.getColumnIndexOrThrow("last_scrap_at");
            if (_cursor.moveToFirst()) {
                int _tmp_id = _cursor.getInt(_cursorIndexOfId);
                String _tmpMMallName = _cursor.getString(_cursorIndexOfMMallName);
                String _tmpMUserId = _cursor.getString(_cursorIndexOfMUserId);
                String _tmpMPassword = _cursor.getString(_cursorIndexOfMPassword);
                String _tmpMLastScrapAt = _cursor.getString(_cursorIndexOfMLastScrapAt);
                _result = new UserEntity(_tmp_id, _tmpMMallName, _tmpMUserId, _tmpMPassword, _tmpMLastScrapAt);
            } else {
                _result = null;
            }
            UserEntity userEntity = _result;
            return userEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserEntity getUser(String mall) {
        String _sql = "SELECT * FROM users WHERE mall_name = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users WHERE mall_name = ?", (int)1);
        int _argIndex = 1;
        if (mall == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, mall);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            UserEntity _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfMMallName = _cursor.getColumnIndexOrThrow("mall_name");
            int _cursorIndexOfMUserId = _cursor.getColumnIndexOrThrow("uid");
            int _cursorIndexOfMPassword = _cursor.getColumnIndexOrThrow("pwd");
            int _cursorIndexOfMLastScrapAt = _cursor.getColumnIndexOrThrow("last_scrap_at");
            if (_cursor.moveToFirst()) {
                int _tmp_id = _cursor.getInt(_cursorIndexOfId);
                String _tmpMMallName = _cursor.getString(_cursorIndexOfMMallName);
                String _tmpMUserId = _cursor.getString(_cursorIndexOfMUserId);
                String _tmpMPassword = _cursor.getString(_cursorIndexOfMPassword);
                String _tmpMLastScrapAt = _cursor.getString(_cursorIndexOfMLastScrapAt);
                _result = new UserEntity(_tmp_id, _tmpMMallName, _tmpMUserId, _tmpMPassword, _tmpMLastScrapAt);
            } else {
                _result = null;
            }
            UserEntity userEntity = _result;
            return userEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

