package com.tenqube.visual_scraper.api;

import android.content.SharedPreferences;

import com.tenqube.visual_scraper.constants.Constants;

import java.io.IOException;
import java.net.URISyntaxException;

import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderInterceptor implements Interceptor {

    private final SharedPreferences preferences;

    public HeaderInterceptor(SharedPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        HttpUrl host = HttpUrl.parse(String.format(ScrapApiService.BASE_URL, preferences.getString(Constants.PREF_KEY.LAYER, "dev")));
        HttpUrl newUrl = null;
        try {
            newUrl = chain.request().url().newBuilder().scheme(host.scheme()).host(host.url().toURI().getHost()).port(host.port()).build();
        } catch (URISyntaxException e) {
            e.printStackTrace();
            newUrl = host;
        }

        Request request = chain.request().newBuilder()
                .url(newUrl)
                .addHeader(Constants.API.X_API_KEY, preferences.getString(Constants.PREF_KEY.X_API_KEY, "")).build();
        return chain.proceed(request);
    }

}
