/*
 * Copyright 2017, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.tenqube.visual_scraper.db.entity.ScrapEntity;

import java.util.List;


@Dao
public interface ScrapDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void inserts(List<ScrapEntity> scraps);

    @Query( "SELECT * " +
            "FROM scraps WHERE name = :mall")
    ScrapEntity getScrap(String mall);


}
