/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.visualserver;

import android.content.Context;
import android.support.annotation.NonNull;
import com.tenqube.visual_scraper.data.dto_data.RuleData;
import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.RequestOrders;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApi;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApiService;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualCallAdapter;
import com.tenqube.visual_scraper.utils.LogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class VisualApiImpl
implements VisualApi {
    private VisualApiService mApiService;
    private static VisualApiImpl mInstance = null;
    private static final String TAG = LogUtil.makeLogTag(VisualApiImpl.class.getSimpleName());
    private Interceptor intercepter = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request original = chain.request();
            Request request = VisualApiImpl.this.getRequest(original);
            Response response = chain.proceed(request);
            LogUtil.LOGI(TAG, "Visual Url:" + request.url().toString() + "/ Visual code : " + response.code());
            if (response.code() == 401) {
                try {
                    response.body().close();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                Request modifiedRequest = VisualApiImpl.this.getRequest(request);
                return chain.proceed(modifiedRequest);
            }
            return response;
        }
    };

    public static VisualApiImpl getInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new VisualApiImpl(ctx.getApplicationContext());
        }
        return mInstance;
    }

    private VisualApiImpl(Context context) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(this.intercepter);
        OkHttpClient client = httpClient.connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://17uz081ava.execute-api.ap-northeast-2.amazonaws.com/dev/").addCallAdapterFactory((CallAdapter.Factory)new VisualCallAdapter.VisualCallAdapterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(client).build();
        this.mApiService = (VisualApiService)retrofit.create(VisualApiService.class);
    }

    Request getRequest(Request origin) {
        return origin.newBuilder().header("User-Agent", "Android").method(origin.method(), origin.body()).build();
    }

    @Override
    public void callPurchaseParsing(final OnNetworkResultListener<Orders> callback, RequestDocumentData requestDocumentData) {
        Call<Orders> parsingRuleDataMyCall = this.mApiService.callPurchaseParser(requestDocumentData);
        parsingRuleDataMyCall.enqueue((Callback)new Callback<Orders>(){

            public void onResponse(@NonNull Call<Orders> call, @NonNull retrofit2.Response<Orders> response) {
                LogUtil.LOGI(TAG, "parsing response" + response.body());
                callback.onResult(response.body());
            }

            public void onFailure(@NonNull Call<Orders> call, @NonNull Throwable t) {
                callback.onFailResult(400);
            }
        });
    }

    @Override
    public void callDetailPurchaseParsing(final OnNetworkResultListener<Orders> callback, RequestDocumentData requestDocumentData) {
        Call<Orders> parsingRuleDataMyCall = this.mApiService.callPurchaseParser(requestDocumentData);
        parsingRuleDataMyCall.enqueue((Callback)new Callback<Orders>(){

            public void onResponse(@NonNull Call<Orders> call, @NonNull retrofit2.Response<Orders> response) {
                LogUtil.LOGI(TAG, "detail parsing  response " + response.body());
                callback.onResult(response.body());
            }

            public void onFailure(@NonNull Call<Orders> cal\u00e6l, @NonNull Throwable t) {
                LogUtil.LOGI(TAG, "error");
                callback.onFailResult(400);
            }
        });
    }

    @Override
    public void callScrapingRule(final OnNetworkResultListener<RuleData> callback, int version) {
        VisualCallAdapter.MyCall<RuleData> parsingRuleDataMyCall = this.mApiService.callScrapingRule(version);
        parsingRuleDataMyCall.enqueue(new VisualCallAdapter.MyCallback<RuleData>(){

            @Override
            public void success(retrofit2.Response<RuleData> response) {
                if (response.body() != null) {
                    LogUtil.LOGI(TAG, "Scraping Rule response " + response.body());
                }
                callback.onResult(response.body());
            }

            @Override
            public void deny() {
            }

            @Override
            public void fail(retrofit2.Response<?> response) {
                callback.onFailResult(response.code());
            }
        });
    }

    @Override
    public void callOrders(final OnNetworkResultListener<Void> callback, RequestOrders requestOrders) {
        LogUtil.LOGI(TAG, requestOrders.toString());
        VisualCallAdapter.MyCall<Void> call = this.mApiService.callOrders(requestOrders);
        call.enqueue(new VisualCallAdapter.MyCallback<Void>(){

            @Override
            public void success(retrofit2.Response<Void> response) {
                callback.onResult(response.body());
            }

            @Override
            public void deny() {
            }

            @Override
            public void fail(retrofit2.Response<?> response) {
                callback.onFailResult(response.code());
            }
        });
    }

    public static interface OnNetworkResultListener<T> {
        public void onResult(T var1);

        public void onFailResult(int var1);
    }
}

