/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.request_data.RequestContentData;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.scraper.ScrapingOnlineMall;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.utils.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class PageParser
implements PurchaseRequest {
    public static final String TAG = PageParser.class.getSimpleName();
    private PurchaseRequest.OnResponsePurchasePage mListener;
    private ParsingRuleData mParsingRuleData;
    private Runnable runnable;

    public PageParser(PurchaseRequest.OnResponsePurchasePage mListener, ParsingRuleData parsingRuleData) {
        this.mListener = mListener;
        this.mParsingRuleData = parsingRuleData;
    }

    private Connection.Response callGetRequest(String url, String cookie, Map<String, String> queryParams) {
        try {
            LogUtil.LOGI(TAG, "REUQEST_GET_URL" + url);
            LogUtil.LOGI(TAG, "REUQEST_GET_PARAMS" + queryParams.toString());
            return Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).data(queryParams).timeout(6000).ignoreContentType(true).header("cookie", cookie).method(Connection.Method.GET).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Connection.Response callPostRequest(String url, String cookie, Map<String, String> postParams) {
        try {
            LogUtil.LOGI(TAG, "REUQEST_POST_URL" + url);
            LogUtil.LOGI(TAG, "REUQEST_POST_PARAMS" + postParams.toString());
            return Jsoup.connect((String)url).userAgent("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36").followRedirects(true).timeout(6000).ignoreContentType(true).header("cookie", cookie).method(Connection.Method.POST).data(postParams).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void doPurchasePageRequest(String cookie) {
        try {
            Connection.Response response;
            if (this.mParsingRuleData.purchaseMethodType == 0) {
                response = this.callGetRequest(this.mParsingRuleData.purchaseUrl, cookie, this.mParsingRuleData.purchaseParams);
                LogUtil.LOGI(TAG, " get purchase BODY " + this.mParsingRuleData.purchaseParams.toString());
            } else {
                response = this.callPostRequest(this.mParsingRuleData.purchaseUrl, cookie, this.mParsingRuleData.purchaseParams);
                LogUtil.LOGI(TAG, " post purchase BODY ");
            }
            if (response != null) {
                Document doc = response.parse();
                if (doc != null) {
                    RequestDocumentData requestDocumentData = new RequestDocumentData();
                    requestDocumentData.contents = new ArrayList();
                    RequestContentData requestData = new RequestContentData();
                    if (response.contentType().contains("application/json")) {
                        requestData.contentType = 1;
                        requestData.content = doc.select("body").html();
                    } else {
                        requestData.contentType = 0;
                        if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE.booleanValue()) {
                            for (Element ele : doc.select(this.mParsingRuleData.purchaseDivCss)) {
                                LogUtil.LOGI(TAG, "URL_ENCODED " + ele.html());
                            }
                        }
                        requestData.content = doc.select(this.mParsingRuleData.purchaseDivCss).outerHtml();
                    }
                    requestDocumentData.contents.add(requestData);
                    requestDocumentData.name = this.mParsingRuleData.name;
                    requestDocumentData.parsingType = 0;
                    LogUtil.LOGI(TAG, " call URl " + response.url());
                    LogUtil.LOGI(TAG, "\uc8fc\ubb38\ud398\uc774\uc9c0 BODY ," + requestData.toString());
                    this.mListener.onPurchasePageResult(requestDocumentData);
                } else {
                    this.mListener.onParsingFail("request document null");
                }
            } else {
                this.mListener.onParsingFail("request response null");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<ScrapData> getMakeDetailScrapData(ArrayList<Order> parsedOrderData) {
        ArrayList<ScrapData> detailScrapDatas = new ArrayList<ScrapData>();
        for (Order order : parsedOrderData) {
            LogUtil.LOGI(TAG, "DetailParsingRule " + order.orderNum);
            ScrapData scrapData = new ScrapData();
            if (this.mParsingRuleData.detailParams != null) {
                scrapData.params = Validator.convertMapToString(this.mParsingRuleData.detailParams);
                for (String key : scrapData.params.keySet()) {
                    if (!scrapData.params.get(key).contains("dynamicOrderNum")) continue;
                    scrapData.params.put(key, order.orderNum);
                }
                scrapData.url = this.mParsingRuleData.detailDomainUrl;
            } else {
                scrapData.params = new HashMap();
                scrapData.url = order.orderNum != null && !order.orderNum.isEmpty() ? this.mParsingRuleData.detailDomainUrl + order.orderNum : order.detailOrder.link;
            }
            scrapData.divCss = this.mParsingRuleData.detailPageDivCss;
            scrapData.methodType = this.mParsingRuleData.detailMetodtype;
            detailScrapDatas.add(scrapData);
        }
        return detailScrapDatas;
    }

    @Override
    public void doDetailPurchasePageRequest(String cookie, ArrayList<Order> parsedOrderData) {
        if (this.mParsingRuleData.detailPageDivCss == null || this.mParsingRuleData.detailPageDivCss.isEmpty()) {
            return;
        }
        RequestDocumentData requestData = new RequestDocumentData();
        requestData.contents = new ArrayList();
        requestData.name = this.mParsingRuleData.name;
        requestData.parsingType = 1;
        LogUtil.LOGI(TAG, "DetailParsingRule " + this.mParsingRuleData.toString());
        ArrayList<ScrapData> detailScrapData = this.getMakeDetailScrapData(parsedOrderData);
        try {
            for (ScrapData scrapData : detailScrapData) {
                Connection.Response response = scrapData.methodType == 0 ? this.callGetRequest(scrapData.url, cookie, scrapData.params) : this.callPostRequest(scrapData.url, cookie, scrapData.params);
                if (response == null) continue;
                RequestContentData requestContent = new RequestContentData();
                Document detailPage = response.parse();
                int n = requestContent.contentType = response.contentType().contains("application/json") ? 1 : 0;
                if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE.booleanValue()) {
                    for (Element ele : detailPage.select(scrapData.divCss)) {
                        LogUtil.LOGI(TAG, "\uc0c1\uc138\ud398\uc774\uc9c0 BODY ," + ele.html());
                    }
                }
                if (detailPage == null) continue;
                requestContent.content = detailPage.select(scrapData.divCss).html();
                requestData.contents.add(requestContent);
            }
            if (requestData.contents.size() > 0) {
                this.mListener.onDetailPurchasePageResult(requestData);
            } else {
                this.mListener.onParsingFail("Fail detail scraping or empty");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

