package com.tenqube.visual_scraper.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import static com.tenqube.visual_scraper.constants.Constants.DYNAMIC_KEY.DYNAMIC_DATE;
import static com.tenqube.visual_scraper.constants.Constants.DYNAMIC_KEY.DYNAMIC_END;

/**
 * Created by tenqube on 2018. 5. 8..
 */

public class Validator {





    public static HashMap<String, String> convertMapToString(String json) {
        JsonParser jsonParser = new JsonParser();
        JsonObject object = (JsonObject) jsonParser.parse(json);
        Set<Map.Entry<String, JsonElement>> set = object.entrySet();
        Iterator<Map.Entry<String, JsonElement>> iterator = set.iterator();
        HashMap<String, String> map = new HashMap<>();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonElement> entry = iterator.next();
            String key = entry.getKey();
            JsonElement value = entry.getValue();
            if (!value.isJsonPrimitive()) {
                map.put(key, String.valueOf(convertMapToString(value.toString())));
            } else {
                map.put(key, value.getAsString());
            }
        }
        return map;

    }

    public static String replaceDateParams(String originStr,String lastSyncDate){
        while(originStr.contains(DYNAMIC_DATE)){
            String dateStr;
            int startPosition = originStr.indexOf(DYNAMIC_DATE);
            int endPosition = originStr.indexOf(DYNAMIC_END);
            dateStr = originStr.substring(startPosition+12,endPosition-1);
            originStr = originStr.replaceFirst(DYNAMIC_DATE +":","").replaceFirst(dateStr,DateUtils.getParamsDate(dateStr,lastSyncDate)).replaceFirst(":"+ DYNAMIC_END,"");
        }
        return originStr;
    }





    public static String convertMaptoString(Map<String, String> cookies) {
    StringBuilder cookie = new StringBuilder();

        int i = 0;
        for (String key : cookies.keySet()){
            i++;
            if (i==cookies.keySet().size())
                cookie.append(key).append("=").append(cookies.get(key));
            else
                cookie.append(key).append("=").append(cookies.get(key)).append(";");
        }

        return cookie.toString();
    }
}
