package com.tenqube.visual_scraper.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.annotation.Nullable;

import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApi;
import com.tenqube.visual_scraper.request_interface.visualserver.VisualApiImpl;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 6. 15..
 */

public class ParsingService extends IntentService {
    static final String TAG = ParsingService.class.getSimpleName();

    public static final int PARSING_START = 0;
    public static final int PARSING_FINISHED = 1;
    public static final int PARSING_ERROR =2;

    public static final String RECEIVER = "scrper_receiver";
    public static final String PURCHASE_HTML = "purchase_html";
    public static final String MALL_ID = "mall_id";
    public static final String USER_ID = "user_id";

    VisualApi visualApi;
    ResultReceiver receiver = null;


    public ParsingService() {
        super("ParsingService");
        visualApi = VisualApiImpl.getInstance(this);
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {

        if (intent != null) {
            receiver =  intent.getParcelableExtra(RECEIVER);
            receiver.send(PARSING_START, new Bundle());
            RequestDocumentData purchaseHtml = (RequestDocumentData) intent.getSerializableExtra(PURCHASE_HTML);
            final String userID = intent.getStringExtra(USER_ID);
            final int mallId = intent.getIntExtra(MALL_ID, 0);

            LOGI(TAG, purchaseHtml.toString());
            visualApi.callPurchaseParsing(new VisualApiImpl.OnNetworkResultListener<Orders>() {
                @Override
                public void onResult(Orders orders) {
                    Bundle bundle = new Bundle();
                    bundle.putSerializable("Orders",orders);
                        receiver.send(PARSING_FINISHED,bundle );
                }

                @Override
                public void onFailResult(int i) {
                    receiver.send(PARSING_ERROR, new Bundle());

                }
            }, purchaseHtml);
        }
    }
}
