package com.tenqube.visual_scraper.request_interface.visualserver;

import com.tenqube.visual_scraper.data.dto_data.RuleData;
import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.RequestOrders;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by tenqube on 2018. 6. 14..
 */

public interface VisualApiService {


    /**
     * 파싱룰 서버 동기화
     * @param version 동기화 필드
     * @return
     */
    @GET("sync-rule/{version}")
    VisualCallAdapter.MyCall<RuleData> callScrapingRule(@Path("version")int version);


    /**
     *
     * @param requestDocumentData 주문페이지 데이터
     * @return Orders
     */
    @POST("purchase-parser")
    Call<Orders> callPurchaseParser(@Body RequestDocumentData requestDocumentData);


    /**
     *
     * @param requestDocumentData 상세페이지 데이터
     * @return OrderData
     */
    @POST("detail-parser")
    VisualCallAdapter.MyCall<Order> callDetailParser(@Body RequestDocumentData requestDocumentData);

    /******************************************* SCRAPING ********************************************************/
    @POST("orders")
    VisualCallAdapter.MyCall<Void> callOrders(@Body RequestOrders requestOrders);

}
