package com.tenqube.visual_scraper.request_interface.visualserver;

import android.content.Context;
import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.data.dto_data.RuleData;
import com.tenqube.visual_scraper.data.parsed_data.Orders;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.RequestOrders;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;
import static com.tenqube.visual_scraper.utils.LogUtil.makeLogTag;

/**
 * Created by tenqube on 2018. 6. 14..cw.jeon
 */

public class VisualApiImpl implements VisualApi {

    private VisualApiService mApiService;
    private static VisualApiImpl mInstance =null;
    private static final String TAG = makeLogTag((VisualApiImpl.class).getSimpleName());


    public static VisualApiImpl getInstance(Context ctx){
        if (mInstance ==null){
            mInstance = new VisualApiImpl(ctx.getApplicationContext());
        }
        return mInstance;
    }

    private VisualApiImpl(Context context) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(intercepter);
        OkHttpClient client = httpClient
                .connectTimeout(3, TimeUnit.SECONDS)
                .writeTimeout(3, TimeUnit.SECONDS)
                .readTimeout(3, TimeUnit.SECONDS)
                .build();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl("https://17uz081ava.execute-api.ap-northeast-2.amazonaws.com/dev/")
                .addCallAdapterFactory(new VisualCallAdapter.VisualCallAdapterFactory())
                .addConverterFactory(GsonConverterFactory.create())
                .client(client)
                .build();
        mApiService = retrofit.create(VisualApiService.class);
    }

    private Interceptor intercepter = new Interceptor() {
        @Override
        public Response intercept(Chain chain) throws IOException {

            Request original = chain.request();
            Request request = getRequest(original);
            Response response = chain.proceed(request);
            LOGI(TAG, "Visual Url:" + request.url().toString() + "/ Visual code : " + response.code());


            if (response.code() == 401) {

                try {
                    response.body().close();
                } catch (NullPointerException e) {
                    e.printStackTrace();
                }


                Request modifiedRequest = getRequest(request);
                return chain.proceed(modifiedRequest);
            } else {
                return response;
            }
        }
    };

    Request getRequest(Request origin) {

        return origin.newBuilder()
                .header("User-Agent", "Android")
                .method(origin.method(), origin.body())
                .build();
    }
    @Override
    public void callPurchaseParsing(final OnNetworkResultListener<Orders> callback, final RequestDocumentData requestDocumentData) {
        Call<Orders> parsingRuleDataMyCall = mApiService.callPurchaseParser(requestDocumentData);

        parsingRuleDataMyCall.enqueue(new Callback<Orders>() {
            @Override
            public void onResponse(@NonNull Call<Orders> call, @NonNull retrofit2.Response<Orders> response) {
                LOGI(TAG, "parsing response" + response.body());
                callback.onResult(response.body());
            }

            @Override
            public void onFailure(@NonNull Call<Orders> call, @NonNull Throwable t) {
                callback.onFailResult(400);
            }
        });
    }

    @Override
    public void callDetailPurchaseParsing(final OnNetworkResultListener<Orders> callback, RequestDocumentData requestDocumentData) {

        Call<Orders> parsingRuleDataMyCall = mApiService.callPurchaseParser(requestDocumentData);

        parsingRuleDataMyCall.enqueue(new Callback<Orders>() {
            @Override
            public void onResponse(@NonNull Call<Orders> call, @NonNull retrofit2.Response<Orders> response) {
                LOGI(TAG, "detail parsing  response " + response.body());
                callback.onResult(response.body());

            }

            @Override
            public void onFailure(@NonNull Call<Orders> calæl, @NonNull Throwable t) {
                LOGI(TAG, "error" );
                callback.onFailResult(400);
            }
        });

    }


    public interface OnNetworkResultListener<T> {
        void onResult(T result);

        void onFailResult(int code);
    }



    @Override
    public void callScrapingRule(final VisualApiImpl.OnNetworkResultListener<RuleData> callback, final int version) {
        VisualCallAdapter.MyCall<RuleData> parsingRuleDataMyCall = mApiService.callScrapingRule(version);
        parsingRuleDataMyCall.enqueue(new VisualCallAdapter.MyCallback<RuleData>() {
            @Override
            public void success(retrofit2.Response<RuleData> response) {
                if (response.body()!=null)
                    LOGI(TAG, "Scraping Rule response " + response.body());
                    callback.onResult(response.body());

            }

            @Override
            public void deny() {

            }

            @Override
            public void fail(retrofit2.Response<?> response) {
                callback.onFailResult(response.code());
            }
        });
    }


    @Override
    public void callOrders(final OnNetworkResultListener<Void> callback, RequestOrders requestOrders) {

        LOGI(TAG,requestOrders.toString());
        final VisualCallAdapter.MyCall<Void> call = mApiService.callOrders(requestOrders);
        call.enqueue(new VisualCallAdapter.MyCallback<Void>() {
            @Override
            public void success(retrofit2.Response<Void> response) {
                callback.onResult(response.body());
            }

            @Override
            public void deny() {

            }

            @Override
            public void fail(retrofit2.Response<?> response) {
                callback.onFailResult(response.code());
            }
        });
    }

}
