package com.tenqube.visual_scraper.request_interface.page;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.parsed_data.Order;
import com.tenqube.visual_scraper.data.request_data.RequestContentData;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.scraper.ScrapingOnlineMall;
import com.tenqube.visual_scraper.utils.Validator;

import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import static com.tenqube.visual_scraper.constants.Constants.METHOD_TYPE.GET;
import static com.tenqube.visual_scraper.constants.Constants.USER_AGENT;
import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class PageParser implements PurchaseRequest {

    public static final String TAG = PageParser.class.getSimpleName();
    private PurchaseRequest.OnResponsePurchasePage mListener;
    private ParsingRuleData mParsingRuleData;
    private Runnable runnable;

    public PageParser(OnResponsePurchasePage mListener, ParsingRuleData parsingRuleData) {
        this.mListener = mListener;
        this.mParsingRuleData = parsingRuleData;

    }


    private Connection.Response callGetRequest(String url, String cookie, Map<String, String> queryParams) {
        try {
            LOGI(TAG, "REUQEST_GET_URL" + url);
            LOGI(TAG, "REUQEST_GET_PARAMS" + queryParams.toString());

            return Jsoup.connect(url)
                    .userAgent(USER_AGENT)
                    .followRedirects(true)
                    .data(queryParams)
                    .timeout(6000)
                    .ignoreContentType(true)
                    .header("cookie", cookie)
                    .method(Connection.Method.GET)
                    .execute();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    private Connection.Response callPostRequest(String url, String cookie, Map<String, String> postParams) {
        try {
            LOGI(TAG, "REUQEST_POST_URL" + url);
            LOGI(TAG, "REUQEST_POST_PARAMS" + postParams.toString());


            return Jsoup.connect(url)
                    .userAgent(USER_AGENT)
                    .followRedirects(true)
                    .timeout(6000)
                    .ignoreContentType(true)
                    .header("cookie", cookie)
                    .method(Connection.Method.POST)
                    .data(postParams)
                    .execute();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void doPurchasePageRequest(String cookie) {

        try {

            Connection.Response response;

            if (mParsingRuleData.purchaseMethodType == GET) {
                response = callGetRequest(mParsingRuleData.purchaseUrl, cookie, mParsingRuleData.purchaseParams);
                LOGI(TAG, " get purchase BODY " + mParsingRuleData.purchaseParams.toString());

            } else {
                response = callPostRequest(mParsingRuleData.purchaseUrl, cookie, mParsingRuleData.purchaseParams);
                LOGI(TAG, " post purchase BODY ");
            }


            if (response != null) {


                Document doc = response.parse();
                if (doc != null) {
                    RequestDocumentData requestDocumentData = new RequestDocumentData();
                    requestDocumentData.contents = new ArrayList<>();

                    RequestContentData requestData = new RequestContentData();
                    if (response.contentType().contains(Constants.CONTENT_TYPE.JSON_KEY)) {

                        requestData.contentType = Constants.CONTENT_TYPE.JSON;
                        requestData.content = doc.select("body").html();
                    } else {
                        requestData.contentType = Constants.CONTENT_TYPE.URL_ENCODED;

                        if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE) {
                            for (Element ele : doc.select(mParsingRuleData.purchaseDivCss)) {
                                LOGI(TAG, "URL_ENCODED " + ele.html());
                            }
                        }
                        requestData.content = doc.select(mParsingRuleData.purchaseDivCss).outerHtml();
                    }

                    requestDocumentData.contents.add(requestData);

                    requestDocumentData.name = mParsingRuleData.name;
                    requestDocumentData.parsingType = Constants.SCRAP_TYPE.PURCHASE;


                    LOGI(TAG, " call URl " + response.url());

                    LOGI(TAG, "주문페이지 BODY ," + requestData.toString());

                    mListener.onPurchasePageResult(requestDocumentData);
                } else {
                    mListener.onParsingFail("request document null");
                }
            } else {
                mListener.onParsingFail("request response null");
            }


        } catch (IOException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }

    }


    public ArrayList<ScrapData> getMakeDetailScrapData(ArrayList<Order> parsedOrderData) {
        ArrayList<ScrapData> detailScrapDatas = new ArrayList<>();

        for (Order order : parsedOrderData) {
            LOGI(TAG, "DetailParsingRule " + order.orderNum);

            ScrapData scrapData = new ScrapData();
            if (mParsingRuleData.detailParams != null) {
                scrapData.params = Validator.convertMapToString(mParsingRuleData.detailParams);
                for (String key : scrapData.params.keySet()) {
                    if (scrapData.params.get(key).contains(Constants.DYNAMIC_KEY.DYNAMIC_ORDER_NUM_KEY)) {
                        scrapData.params.put(key, order.orderNum);
                    }
                }

                scrapData.url = mParsingRuleData.detailDomainUrl;
            } else {
                scrapData.params = new HashMap<>();
                if (order.orderNum != null && !order.orderNum.isEmpty())
                    scrapData.url = mParsingRuleData.detailDomainUrl + order.orderNum;
                else
                    scrapData.url = order.detailOrder.link;
            }

            scrapData.divCss = mParsingRuleData.detailPageDivCss;
            scrapData.methodType = mParsingRuleData.detailMetodtype;
            detailScrapDatas.add(scrapData);
        }
        return detailScrapDatas;
    }

    @Override
    public void doDetailPurchasePageRequest(String cookie, ArrayList<Order> parsedOrderData) {

        if (mParsingRuleData.detailPageDivCss == null || mParsingRuleData.detailPageDivCss.isEmpty()) {
            return;
        }
        //보낼데이터객체 선언 선언
        Connection.Response response;
        Document detailPage;
        RequestDocumentData requestData = new RequestDocumentData();
        requestData.contents = new ArrayList<>();
        requestData.name = mParsingRuleData.name;
        requestData.parsingType = Constants.SCRAP_TYPE.DETAIL_PURCHASE;

        LOGI(TAG, "DetailParsingRule " + mParsingRuleData.toString());
        //보낼데이터 만들기
        ArrayList<ScrapData> detailScrapData = getMakeDetailScrapData(parsedOrderData);

        try {
            for (ScrapData scrapData : detailScrapData) {

                if (scrapData.methodType == Constants.METHOD_TYPE.GET)
                    response = callGetRequest(scrapData.url, cookie, scrapData.params);
                else
                    response = callPostRequest(scrapData.url, cookie, scrapData.params);

                if (response != null) {
                    RequestContentData requestContent = new RequestContentData();
                    detailPage = response.parse();
                    requestContent.contentType = response.contentType().contains(Constants.CONTENT_TYPE.JSON_KEY) ?
                            Constants.CONTENT_TYPE.JSON :
                            Constants.CONTENT_TYPE.URL_ENCODED;

                    if (ScrapingOnlineMall.SCRAPING_DEBUG_MODE) {
                        for (Element ele : detailPage.select(scrapData.divCss)) {
                            LOGI(TAG, "상세페이지 BODY ," + ele.html());
                        }
                    }
                    if (detailPage != null) {
                        requestContent.content = detailPage.select(scrapData.divCss).html();
                        requestData.contents.add(requestContent);
                    }

                }

            }
            if (requestData.contents.size() > 0)

                mListener.onDetailPurchasePageResult(requestData);
            else {
                mListener.onParsingFail("Fail detail scraping or empty");
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
