package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.dto_data.RuleData;
import com.tenqube.visual_scraper.utils.LogUtil;
import com.tenqube.visual_scraper.utils.Validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 5. 31..cw.jeon
 */

public class SyncRuleMallsTable extends AbstractTable implements BaseColumns {

    private static final String TAG = LogUtil.makeLogTag(SyncRuleMallsTable.class);

    public static final String TABLE_NAME = "sync_rule_malls";
    public static final String COLUMN_MALL_ID = "_id";
    public static final String COLUMN_MALL_NAME = "name";
    public static final String COLUMN_DISPLAY_NAME = "display_name";
    public static final String COLUMN_LOGIN_URL = "login_url";
    public static final String COLUMN_LOGO_URL = "icon_url";
    public static final String COLUMN_IS_API_LOGIN = "is_api_login";
    public static final String COLUMN_SCRIPT_CODE = "web_view_script_code";
    public static final String COLUMN_VALID_COOKIE_KEY = "valid_cookie_key";
    public static final String COLUMN_LOGIN_PARAMS = "login_params";
    public static final String COLUMN_EXCEPT_SCRIPT_CODE = "except_script_code";
    public static final String COLUMN_VERSION = "version";
    public static final String COLUMN_PURCHASE_URL = "purchase_url";
    public static final String COLUMN_PURCHASE_DIV_CSS = "purchase_div_css";
    public static final String COLUMN_PURCHASE_METHOD_TYPE = "purchase_method_type";
    public static final String COLUMN_PURCHASE_PARAMS = "purchase_params";

//    detail
    public static final String COLUMN_DETAIL_METHOD_TYPE = "detail_mothod_type";
    public static final String COLUMN_DETAIL_PARAMS = "detail_params";
    public static final String COLUMN_DETAIL_DOMAIN_URL = "detail_domain_url";
    public static final String COLUMN_DETAIL_PAGE_DIV_CSS = "detail_page_div_css";




    public static final String SQL_CREATE_TABLE =
            CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + "(" +
                    COLUMN_MALL_ID + INTEGER_TYPE + PRIMARY_KEY + COMMA_SEP +
                    COLUMN_MALL_NAME + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_DISPLAY_NAME + TEXT_TYPE + COMMA_SEP +
                    COLUMN_LOGO_URL + TEXT_TYPE + COMMA_SEP +

                    //login
                    COLUMN_LOGIN_URL + TEXT_TYPE + COMMA_SEP +
                    COLUMN_IS_API_LOGIN + INTEGER_TYPE +DEFAULT+DEFAULT_INT + COMMA_SEP +
                    COLUMN_SCRIPT_CODE + TEXT_TYPE + COMMA_SEP +
                    COLUMN_VALID_COOKIE_KEY + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_LOGIN_PARAMS + TEXT_TYPE  + COMMA_SEP +

                    //purchase
                    COLUMN_PURCHASE_URL + TEXT_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_PURCHASE_METHOD_TYPE + INTEGER_TYPE +DEFAULT+DEFAULT_INT+ NOT_NULL + COMMA_SEP +
                    COLUMN_PURCHASE_DIV_CSS + TEXT_TYPE+DEFAULT+DEFAULT_TEXT + NOT_NULL + COMMA_SEP +
                    COLUMN_PURCHASE_PARAMS + TEXT_TYPE  + COMMA_SEP +

                    //detail
                    COLUMN_DETAIL_METHOD_TYPE + INTEGER_TYPE  + DEFAULT +DEFAULT_INT+NOT_NULL+COMMA_SEP+
                    COLUMN_DETAIL_PARAMS + TEXT_TYPE  + COMMA_SEP +
                    COLUMN_DETAIL_DOMAIN_URL + TEXT_TYPE  + COMMA_SEP +
                    COLUMN_DETAIL_PAGE_DIV_CSS + TEXT_TYPE  + COMMA_SEP +


                    COLUMN_VERSION + INTEGER_TYPE + NOT_NULL + COMMA_SEP +
                    COLUMN_EXCEPT_SCRIPT_CODE + TEXT_TYPE  + ")";


    public static final String indexing = "CREATE INDEX qlip_sync_rule_malls_idx ON " + TABLE_NAME + " (" + COLUMN_MALL_NAME + " )";

    public static final String SQL_DELETE_ENTRIES =
            DROP_TABLE_IF_EXISTS + TABLE_NAME;


    public static ParsingRuleData populateModel(Cursor c,String userID,String userPw, String lastSyncDate) {
        RuleData.OnlineMall model = new RuleData.OnlineMall();
        model.id = c.getInt(c.getColumnIndex(COLUMN_MALL_ID));
        model.name = c.getString(c.getColumnIndex(COLUMN_MALL_NAME));
        model.displayName = c.getString(c.getColumnIndex(COLUMN_DISPLAY_NAME));
        model.loginUrl = c.getString(c.getColumnIndex(COLUMN_LOGIN_URL));
        model.iconUrl = c.getString(c.getColumnIndex(COLUMN_LOGO_URL));
        model.isWebviewLogin = c.getInt(c.getColumnIndex(COLUMN_IS_API_LOGIN));
        model.scriptCodes = c.getString(c.getColumnIndex(COLUMN_SCRIPT_CODE));
        model.validCookieKeys = c.getString(c.getColumnIndex(COLUMN_VALID_COOKIE_KEY));
        model.loginParams = c.getString(c.getColumnIndex(COLUMN_LOGIN_PARAMS));
        model.purchaseUrl = c.getString(c.getColumnIndex(COLUMN_PURCHASE_URL));
        model.purchaseMethodType = c.getInt(c.getColumnIndex(COLUMN_PURCHASE_METHOD_TYPE));
        model.purchasePageDivCss = c.getString(c.getColumnIndex(COLUMN_PURCHASE_DIV_CSS));
        model.purchaseParams = c.getString(c.getColumnIndex(COLUMN_PURCHASE_PARAMS));
        model.version = c.getInt(c.getColumnIndex(COLUMN_VERSION));
        model.exceptionCodes = c.getString(c.getColumnIndex(COLUMN_EXCEPT_SCRIPT_CODE));
        model.detailMethodType = c.getInt(c.getColumnIndex(COLUMN_DETAIL_METHOD_TYPE));
        model.detailParams = c.getString(c.getColumnIndex(COLUMN_DETAIL_PARAMS));
        model.detailDomainUrl = c.getString(c.getColumnIndex(COLUMN_DETAIL_DOMAIN_URL));
        model.detailPageDivCss = c.getString(c.getColumnIndex(COLUMN_DETAIL_PAGE_DIV_CSS));


        LOGI(TAG,"DTO DATA : "+ model.toString());

        return convertDtoData(model,userID,userPw,lastSyncDate);

    }
    public static  ParsingRuleData convertDtoData(RuleData.OnlineMall dtoParsingRuleData, String userId, String userPw, String lastSyncDate) {
        ParsingRuleData parsingRuleData = new ParsingRuleData();
        if (dtoParsingRuleData != null) {
            parsingRuleData.name = dtoParsingRuleData.name;
            parsingRuleData.displayName = dtoParsingRuleData.displayName;
            parsingRuleData.loginUrl = dtoParsingRuleData.loginUrl;
            parsingRuleData.logoUrl = dtoParsingRuleData.iconUrl;
            parsingRuleData.isApiLogin = dtoParsingRuleData.isWebviewLogin;
            parsingRuleData.exceptScriptCode = new ArrayList<>();

            //webView 로그인 일 경우
            if (dtoParsingRuleData.isWebviewLogin==1 && dtoParsingRuleData.scriptCodes!=null) {
                parsingRuleData.webViewScriptCode = String.format(dtoParsingRuleData.scriptCodes, userId, userPw);
                if (dtoParsingRuleData.exceptionCodes!=null && !dtoParsingRuleData.exceptionCodes.isEmpty())
                    parsingRuleData.exceptScriptCode.add(dtoParsingRuleData.exceptionCodes);
            }
            parsingRuleData.validCookieKey =new ArrayList<>(Arrays.asList(dtoParsingRuleData.validCookieKeys.split(";")));
            parsingRuleData.purchaseUrl = Validator.replaceDateParams(dtoParsingRuleData.purchaseUrl,lastSyncDate);
            parsingRuleData.purchaseDivCss = dtoParsingRuleData.purchasePageDivCss;
            parsingRuleData.purchaseMethodType = dtoParsingRuleData.purchaseMethodType;


            if (dtoParsingRuleData.purchaseParams!=null && !dtoParsingRuleData.purchaseParams.isEmpty()) {
                parsingRuleData.purchaseParams = Validator.convertMapToString(dtoParsingRuleData.purchaseParams);
                for (String key: parsingRuleData.purchaseParams.keySet()){
                    if (parsingRuleData.purchaseParams.get(key).startsWith(Constants.DYNAMIC_KEY.DYNAMIC_DATE)){
                        String value = parsingRuleData.purchaseParams.get(key);
                        parsingRuleData.purchaseParams.put(key,Validator.replaceDateParams(value,lastSyncDate));
                    }
                }
            }else{
                parsingRuleData.purchaseParams = new HashMap<>();
            }

            if (dtoParsingRuleData.loginParams!=null && !dtoParsingRuleData.loginParams.isEmpty()) {
                parsingRuleData.loginParams = Validator.convertMapToString(dtoParsingRuleData.loginParams);

                for (String key : parsingRuleData.loginParams.keySet()) {
                    if (parsingRuleData.loginParams.get(key).contains(Constants.DYNAMIC_KEY.DYNAMIC_USER_ID_KEY)) {
                        parsingRuleData.loginParams.put(key, userId);
                    } else if (parsingRuleData.loginParams.get(key).contains(Constants.DYNAMIC_KEY.DYNAMIC_USER_PW_KEY)) {
                        parsingRuleData.loginParams.put(key, userPw);
                    }
                }
            }


            parsingRuleData.detailParams =  dtoParsingRuleData.detailParams;
            parsingRuleData.detailPageDivCss = dtoParsingRuleData.detailPageDivCss;
            parsingRuleData.detailDomainUrl = dtoParsingRuleData.detailDomainUrl;
            parsingRuleData.detailMetodtype = dtoParsingRuleData.detailMethodType;



        }

        LOGI(TAG,"ParsingRuleData : "+ parsingRuleData.toString());
        return parsingRuleData;
    }



    public static ContentValues populateContent(RuleData.OnlineMall parsingRuleData) {

        ContentValues contentValues = new ContentValues();
        contentValues.put(SyncRuleMallsTable.COLUMN_MALL_NAME, parsingRuleData.name);
        contentValues.put(SyncRuleMallsTable.COLUMN_DISPLAY_NAME, parsingRuleData.displayName);
        contentValues.put(SyncRuleMallsTable.COLUMN_VALID_COOKIE_KEY, parsingRuleData.validCookieKeys);
        contentValues.put(SyncRuleMallsTable.COLUMN_EXCEPT_SCRIPT_CODE, parsingRuleData.exceptionCodes);
        contentValues.put(SyncRuleMallsTable.COLUMN_IS_API_LOGIN, parsingRuleData.isWebviewLogin);
        contentValues.put(SyncRuleMallsTable.COLUMN_SCRIPT_CODE, parsingRuleData.scriptCodes);
        contentValues.put(SyncRuleMallsTable.COLUMN_LOGIN_PARAMS, parsingRuleData.loginParams);
        contentValues.put(SyncRuleMallsTable.COLUMN_LOGIN_URL, parsingRuleData.loginUrl);
        contentValues.put(SyncRuleMallsTable.COLUMN_PURCHASE_URL, parsingRuleData.purchaseUrl);
        contentValues.put(SyncRuleMallsTable.COLUMN_PURCHASE_METHOD_TYPE, parsingRuleData.purchaseMethodType);
        contentValues.put(SyncRuleMallsTable.COLUMN_PURCHASE_PARAMS, parsingRuleData.purchaseParams);
        contentValues.put(SyncRuleMallsTable.COLUMN_PURCHASE_DIV_CSS, parsingRuleData.purchasePageDivCss);
        contentValues.put(SyncRuleMallsTable.COLUMN_VERSION, parsingRuleData.version);
        contentValues.put(SyncRuleMallsTable.COLUMN_LOGO_URL,parsingRuleData.iconUrl);
        contentValues.put(SyncRuleMallsTable.COLUMN_DETAIL_METHOD_TYPE,parsingRuleData.detailMethodType);
        contentValues.put(SyncRuleMallsTable.COLUMN_DETAIL_PARAMS,parsingRuleData.detailParams);
        contentValues.put(SyncRuleMallsTable.COLUMN_DETAIL_DOMAIN_URL,parsingRuleData.detailDomainUrl);
        contentValues.put(SyncRuleMallsTable.COLUMN_DETAIL_PAGE_DIV_CSS,parsingRuleData.detailPageDivCss);
        return contentValues;


    }

}
