/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;
import com.tenqube.visual_scraper.data.ShoppingMallData;
import com.tenqube.visual_scraper.db.table.AbstractTable;

public class ShoppingMallTable
extends AbstractTable
implements BaseColumns {
    public static final String TABLE_NAME = " shopping_mall";
    public static final String ALIAS = " shopping_mall.";
    public static final String AS_ALIAS = " AS shpping_mall ";
    public static final String COLUMN_MALL_ID = "shopping_mall_id_pk";
    public static final String COLUMN_MALL_NAME = "mall_name";
    public static final String COLUMN_MALL_ICON_URL = "mall_icon_url";
    public static final String COLUMN_MAIN_TYPE = "shopping_mall_main_type";
    public static final String COLUMN_PRIORITY = "priority";
    public static final String COLUMN_LAST_SYNC_DATE = "last_sync_date";
    public static final String SQL_CREATE_TABLE = " CREATE TABLE IF NOT EXISTS  shopping_mall (shopping_mall_id_pk INTEGER  PRIMARY KEY  , mall_name TEXT  NOT NULL  , mall_icon_url TEXT  , shopping_mall_main_type INTEGER  DEFAULT  0  , priority INTEGER  DEFAULT  0  , last_sync_date DATETIME  ,  FOREIGN KEY(mall_name) REFERENCES sync_rule_malls(name) ON DELETE CASCADE ,  UNIQUE (mall_name) )";
    public static final String indexing = "CREATE INDEX qlip_shopping_mall_idx ON  shopping_mall (mall_name , shopping_mall_id_pk)";
    public static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  shopping_mall";
    public static final String INSERT_INIT = "INSERT OR REPLACE INTO  shopping_mall(mall_name,shopping_mall_id_pk) VALUES ";

    public static ShoppingMallData populateModel(Cursor c) {
        ShoppingMallData model = new ShoppingMallData();
        model.id = c.getInt(c.getColumnIndex(COLUMN_MALL_ID));
        model.mallName = c.getString(c.getColumnIndex(COLUMN_MALL_NAME));
        model.priority = c.getInt(c.getColumnIndex(COLUMN_PRIORITY));
        model.mainType = c.getInt(c.getColumnIndex(COLUMN_MAIN_TYPE));
        model.lastSyncDate = c.getString(c.getColumnIndex(COLUMN_LAST_SYNC_DATE));
        return model;
    }

    public static ContentValues populateContent(ShoppingMallData model) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_MALL_NAME, model.mallName);
        values.put(COLUMN_MAIN_TYPE, Integer.valueOf(model.mainType));
        values.put(COLUMN_PRIORITY, Integer.valueOf(model.priority));
        return values;
    }
}

