/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.tenqube.visual_scraper.utils.LogUtil;

public class ScraperDatabaseHelper
extends SQLiteOpenHelper {
    private static ScraperDatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = ".com.scraper.db";
    private static final int DATABASE_VERSION = 1;
    protected static final String TAG = LogUtil.makeLogTag(ScraperDatabaseHelper.class);
    private Context mContext;

    private ScraperDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScraperDatabaseHelper getInstance(Context context) {
        Class<ScraperDatabaseHelper> clazz = ScraperDatabaseHelper.class;
        synchronized (ScraperDatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new ScraperDatabaseHelper(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(" CREATE TABLE IF NOT EXISTS sync_rule_malls(_id INTEGER  PRIMARY KEY  , name TEXT  NOT NULL  , display_name TEXT  , login_url TEXT  , is_api_login INTEGER  DEFAULT  0  , web_view_script_code TEXT  , valid_cookie_key TEXT  NOT NULL  , login_params TEXT  , purchase_url TEXT  NOT NULL  , purchase_method_type INTEGER  DEFAULT  0  NOT NULL  , purchase_div_css TEXT  DEFAULT  'none'  NOT NULL  , purchase_params TEXT  , version INTEGER  NOT NULL  , except_script_code TEXT )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  shopping_mall (shopping_mall_id_pk INTEGER  PRIMARY KEY  , mall_name TEXT  NOT NULL  , mall_icon_url TEXT  , shopping_mall_main_type INTEGER  DEFAULT  0  , priority INTEGER  DEFAULT  0  , last_sync_date DATETIME  ,  FOREIGN KEY(mall_name) REFERENCES sync_rule_malls(name) ON DELETE CASCADE ,  UNIQUE (mall_name) )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  mall_user (shopping_mall_user_id TEXT  NOT NULL  , shopping_mall_user_pw TEXT  NOT NULL  , shopping_mall_id INTEGER  NOT NULL  ,  FOREIGN KEY(shopping_mall_id) REFERENCES  shopping_mall(shopping_mall_id_pk)  ON DELETE CASCADE )");
        db.execSQL(" CREATE TABLE IF NOT EXISTS  purchase (purchase_id_pk INTEGER  PRIMARY KEY  , mall_id INTEGER  NOT NULL  , purchase_date TEXT  NOT NULL  , purchase_hms TEXT  , mall_user_id TEXT  NOT NULL  , order_number TEXT  NOT NULL  , where_to_buy TEXT  'none'  , product_name TEXT  NOT NULL  , product_price INTEGER  NOT NULL  , product_category TEXT  'none'  , product_option TEXT  'none'  , product_quantity INTEGER  , product_img_address TEXT  'none'  , product_rating REAL  , delivery_company TEXT  'none'  , delivery_price TEXT  'none'  , order_state TEXT  'none'  ,  FOREIGN KEY(mall_id) REFERENCES  shopping_mall(shopping_mall_id_pk)   ON DELETE CASCADE ,  UNIQUE (mall_id , order_number , purchase_date) )");
        db.execSQL("CREATE INDEX qlip_sync_rule_malls_idx ON sync_rule_malls (name )");
        db.execSQL("CREATE INDEX qlip_shopping_mall_idx ON  shopping_mall (mall_name , shopping_mall_id_pk)");
        db.execSQL("CREATE UNIQUE INDEX qlip_mall_user_idx ON  mall_user (shopping_mall_id , shopping_mall_user_id)");
        db.execSQL("CREATE INDEX qlip_purchase_idx ON  purchase (order_number,mall_user_id)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            switch (oldVersion) {
                default: 
            }
        }
    }
}

