package com.tenqube.visual_scraper.scraper;

import android.app.Activity;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.data.request_data.RequestDocumentData;
import com.tenqube.visual_scraper.data.request_data.ScrapData;
import com.tenqube.visual_scraper.request_interface.login.ApiLogin;
import com.tenqube.visual_scraper.request_interface.login.LoginRequest;
import com.tenqube.visual_scraper.request_interface.login.WebViewLogin;
import com.tenqube.visual_scraper.request_interface.page.PageParser;
import com.tenqube.visual_scraper.request_interface.page.PurchaseRequest;
import com.tenqube.visual_scraper.request_interface.result.OnPurchaseResult;

import java.util.ArrayList;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class ScrapingOnlineMall implements LoginRequest.OnResponse, PurchaseRequest.OnResponsePurchasePage {

    private PurchaseRequest mPurchaseRequest;
    private OnPurchaseResult mListener;
    private LoginRequest mLoginRequest;
    private String mCookie;
    public static Boolean SCRAPING_DEBUG_MODE = false;

    private final static String TAG = ScrapingOnlineMall.class.getSimpleName();

    public ScrapingOnlineMall(Activity activity, ParsingRuleData parsingRuleData, OnPurchaseResult listener,boolean debugMode) {

        SCRAPING_DEBUG_MODE = debugMode;

        if (parsingRuleData.isApiLogin == 0) {
            mLoginRequest = new ApiLogin(parsingRuleData);
        } else {
            mLoginRequest = new WebViewLogin(activity, parsingRuleData);
        }

        mListener = listener;
        mPurchaseRequest = new PageParser(this, parsingRuleData);

        mLoginRequest.setOnResponseCallbackListener(this);
    }

    public void start() {

        new Thread(new Runnable() {
            @Override
            public void run() {

                mLoginRequest.doLogin();
            }
        }).start();

    }

    @Override
    public void onLoginSuccess(String cookie) {
        this.mCookie = cookie;
        mListener.onLoginSuccess(Constants.MESSAGES.LOGIN_SUCCESS);
        //call page
        mListener.onPurchaseStart(Constants.MESSAGES.PURCHASE_START);
        mPurchaseRequest.doPurchasePageRequest(cookie);


    }

    @Override
    public void onLoginFail(int statusCode, String statusMessage) {
        mListener.onFail(statusCode, statusMessage);
    }


    @Override
    public void onPurchasePageResult(RequestDocumentData documents) {

        //구매내역 doc 긇어오기 완료
        mListener.onPurchaseFinished(Constants.MESSAGES.PURCHASE_END, documents);
        //call server


        //이부분을 밖으로 빼야함 onPurchaseFinish 메소드 안에서 콜하기
        

    }

    @Override
    public void onDetailPurchasePageResult(RequestDocumentData detailPurchaseDocuments) {
        mListener.onDetailPageScrapingFinished(Constants.MESSAGES.PURCHASE_END, detailPurchaseDocuments);

    }




    public void detailParsingStart(ArrayList<ScrapData> detailScrapDatas){

        //response받은 데이터 request
        mListener.onDetailPageScrapingStart(Constants.MESSAGES.PURCHASE_START);
        //call server
        mPurchaseRequest.doDetailPurchasePageRequest(mCookie, detailScrapDatas);

    }
    @Override
    public void onParsingFail(String message) {
        mListener.onFail(Constants.STATUSCODE.FAIL_CODE, message);
    }

}
