package com.tenqube.visual_scraper.request_interface.login;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.tenqube.visual_scraper.R;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.data.ParsingRuleData;
import com.tenqube.visual_scraper.utils.LogUtil;

import java.util.Timer;
import java.util.TimerTask;

import static com.tenqube.visual_scraper.utils.LogUtil.LOGI;

/**
 * Created by tenqube on 2018. 5. 18..cw.jeon
 */

public class WebViewLogin implements LoginRequest {
    private LoginRequest.OnResponse mResponse;
    private ParsingRuleData mParsingRuleData;
    private ViewGroup viewGroup;
    private Handler handler;
    private WebView webView;
    private View webViewLayout;
    private boolean isLogin;
    private static final long TiMEOUT_TIMEMILLIS = 30000;
    private Timer timer;
    private static final String TAG = LogUtil.makeLogTag(WebViewLogin.class);

    @SuppressLint({"AddJavascriptInterface", "SetJavaScriptEnabled"})
    public WebViewLogin(Activity activity, ParsingRuleData parsingRuleData) {
        mParsingRuleData = parsingRuleData;
        this.viewGroup = (ViewGroup) activity.getWindow().getDecorView().getRootView();
        this.handler = new Handler();

        LayoutInflater inflater = (LayoutInflater) activity.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        if (inflater != null) {
            webViewLayout = inflater.inflate(R.layout.web_view_layout, null);
            viewGroup.addView(webViewLayout);

            webView = webViewLayout.findViewById(R.id.visual_web_view);

            CookieManager.getInstance().setAcceptCookie(true);
            final CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
                CookieSyncManager.createInstance(activity);
            }
            cookieManager.setAcceptCookie(true);

            webView.getSettings().setJavaScriptEnabled(true);
            webView.getSettings().setUserAgentString(Constants.USER_AGENT);
            webView.setWebViewClient(new WebViewClient() {
                @Override
                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);


                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                        LOGI(TAG, "login URL : "+url);
                        //로그인 스크립트 실행
                        if (!isLogin) {
                            setTimeout();
                            view.loadUrl(mParsingRuleData.webViewScriptCode, null);
                            isLogin = true;

                            //예외화면 스크립트 실행
                        } else if (mParsingRuleData.exceptScriptCode.size() > 0) {
                            view.loadUrl(mParsingRuleData.exceptScriptCode.get(0), null);
                            mParsingRuleData.exceptScriptCode.remove(0);

                            //로그인 완료 쿠키 얻기
                        } else if (cookieManager.getCookie(url) != null) {
                            invalidloginCheck(cookieManager.getCookie(url));
                        }
                    }
                }


                //바뀐 페이지 로그


                @Override
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    return super.shouldOverrideUrlLoading(view, request);
                }
            });

        }
    }


    @Override
    public void doLogin() {
        try {


            handler.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(mParsingRuleData.loginUrl);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    @Override
    public void setOnResponseCallbackListener(OnResponse responseCallbackListener) {
        this.mResponse = responseCallbackListener;

    }

    void closeWebView() {
        if (webView != null) {
            handler.post(new Runnable() {
                @Override
                public void run() {
                    webView.stopLoading();
                    webView.clearCache(true);
                    webView.clearHistory();


                    viewGroup.removeView(webViewLayout);
                    webViewLayout = null;
                    CookieManager cookieManager = CookieManager.getInstance();
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                        cookieManager.removeSessionCookies(new ValueCallback<Boolean>() {
                            @Override
                            public void onReceiveValue(Boolean value) {

                            }
                        });
                    } else {
                        cookieManager.removeSessionCookie();

                    }
                    cookieManager.removeAllCookie();


                }

            });
        }
    }


    private void invalidloginCheck(final String cookie) {
        LOGI(TAG,cookie);
        for (String invalidKey : mParsingRuleData.validCookieKey) {

            if (!cookie.contains(invalidKey)){
                mResponse.onLoginFail(403, Constants.MESSAGES.INVALID_USER_INFO);
                closeWebView();
                return;
            }

        }
        cancelTimeout();
        closeWebView();
        new Thread(new Runnable() {
            @Override
            public void run() {

                mResponse.onLoginSuccess(cookie);
            }
        }).start();

    }


    private void setTimeout() {
        timer = new Timer();
        final TimerTask timerTask = new TimerTask() {
            @Override
            public void run() {
                closeWebView();
                mResponse.onLoginFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
            }
        };

        timer.schedule(timerTask, TiMEOUT_TIMEMILLIS);

    }

    private void cancelTimeout() {
        if (timer != null)
            timer.cancel();

    }
}
