package com.tenqube.visual_scraper.db.table;

import android.content.ContentValues;
import android.database.Cursor;
import android.provider.BaseColumns;

import com.tenqube.visual_scraper.data.MallUserData;

/**
 * Created by tenqube on 2018. 4. 30..
 */

public class ShoppingMallUserInfoTable extends AbstractTable implements BaseColumns{


    public static final String TABLE_NAME = " mall_user";
    public static final String ALIAS = " mall_user.";
    public static final String AS_ALIAS = " AS mall_user ";



    //purchase
    public static final String COLUMN_MALL_USER_ID="shopping_mall_user_id";
    public static final String COLUMN_MALL_USER_PW="shopping_mall_user_pw";
    public static final String COLUMN_MALL_ID = "shopping_mall_id";


    public static final String SQL_CREATE_TABLE =
            CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME + " (" +
                    COLUMN_MALL_USER_ID + TEXT_TYPE +NOT_NULL + COMMA_SEP +
                    COLUMN_MALL_USER_PW + TEXT_TYPE+NOT_NULL  + COMMA_SEP +
                    COLUMN_MALL_ID +INTEGER_TYPE+NOT_NULL+COMMA_SEP+
                    " FOREIGN KEY("+ COLUMN_MALL_ID +") REFERENCES " +
                    ShoppingMallTable.TABLE_NAME+"("+ShoppingMallTable.COLUMN_MALL_ID+
                    ")  ON DELETE CASCADE )";
    public static final String indexing = "CREATE UNIQUE INDEX qlip_mall_user_idx ON " + TABLE_NAME + " ("+COLUMN_MALL_ID+COMMA_SEP+COLUMN_MALL_USER_ID+")";

    public static final String SQL_DELETE_ENTRIES =
            DROP_TABLE_IF_EXISTS + TABLE_NAME;


    /**
     *
     * @param c cursor
     * @return ShoppingMallData
     */
    public static MallUserData populateModel(Cursor c) {
        MallUserData model = new MallUserData();
        model.mallUserId = c.getString(c.getColumnIndex(COLUMN_MALL_USER_ID));
        model.mallUserpw = c.getString(c.getColumnIndex(COLUMN_MALL_USER_PW));
        model.shoppingMallId = c.getInt(c.getColumnIndex(ShoppingMallTable.COLUMN_MALL_ID));
        return model;
    }

    public static ContentValues populateContent(MallUserData model) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_MALL_USER_ID, model.mallUserId);
        values.put(COLUMN_MALL_USER_PW, model.mallUserpw);
        values.put(ShoppingMallTable.COLUMN_MALL_ID, model.shoppingMallId);
        return values;
    }

}
