package com.tenqube.visual_scraper.data.dto_data;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.List;

/**
 * Created by tenqube on 2018. 6. 4..
 */

public class DtoRuleData implements Serializable {

    @Expose
    @SerializedName("onlineMalls")
    public List<OnlineMall> onlineMalls;
    @Expose
    @SerializedName("version")
    public int version;

    @Override
    public String toString() {
        return "DtoRuleData{" +
                "onlineMalls=" + onlineMalls +
                ", version=" + version +
                '}';
    }

    public static class OnlineMall implements Serializable {
        @Expose
        @SerializedName("detailPageDivCss")
        public String detailPageDivCss;
        @Expose
        @SerializedName("detailDomainUrl")
        public String detailDomainUrl;

        @Expose
        @SerializedName("icon_url")
        public String iconUrl;
        @Expose
        @SerializedName("orderNumAttrName")
        public String orderNumAttrName;
        @Expose
        @SerializedName("detailOrdernumDivCss")
        public String detailOrdernumDivCss;
        @Expose
        @SerializedName("orderNumParamKey")
        public String orderNumParamKey;
        @Expose
        @SerializedName("detailParams")
        public String detailParams;
        @Expose
        @SerializedName("detailMethodType")
        public int detailMethodType;
        @Expose
        @SerializedName("purchasePageTblRowCss")
        public String purchasePageTblRowCss;
        @Expose
        @SerializedName("purchaseParams")
        public String purchaseParams;
        @Expose
        @SerializedName("purchaseMethodType")
        public int purchaseMethodType;
        @Expose
        @SerializedName("version")
        public int version;
        @Expose
        @SerializedName("regEx")
        public String regEx;
        @Expose
        @SerializedName("exceptionCodes")
        public String exceptionCodes;
        @Expose
        @SerializedName("scriptCodes")
        public String scriptCodes;
        @Expose
        @SerializedName("purchasePageDivCss")
        public String purchasePageDivCss;
        @Expose
        @SerializedName("validCookieKeys")
        public String validCookieKeys;
        @Expose
        @SerializedName("isWebviewLogin")
        public int isWebviewLogin;
        @Expose
        @SerializedName("loginParams")
        public String loginParams;
        @Expose
        @SerializedName("domain")
        public String domain;
        @Expose
        @SerializedName("purchaseUrl")
        public String purchaseUrl;
        @Expose
        @SerializedName("loginUrl")
        public String loginUrl;
        @Expose
        @SerializedName("displayName")
        public String displayName;
        @Expose
        @SerializedName("name")
        public String name;
        @Expose
        @SerializedName("id")
        public int id;

        @Override
        public String toString() {
            return "OnlineMall{" +
                    "detailPageDivCss='" + detailPageDivCss + '\'' +
                    ", detailDomainUrl='" + detailDomainUrl + '\'' +
                    ", iconUrl='" + iconUrl + '\'' +
                    ", orderNumAttrName='" + orderNumAttrName + '\'' +
                    ", detailOrdernumDivCss='" + detailOrdernumDivCss + '\'' +
                    ", orderNumParamKey='" + orderNumParamKey + '\'' +
                    ", detailParams='" + detailParams + '\'' +
                    ", detailMethodType=" + detailMethodType +
                    ", purchasePageTblRowCss='" + purchasePageTblRowCss + '\'' +
                    ", purchaseParams='" + purchaseParams + '\'' +
                    ", purchaseMethodType=" + purchaseMethodType +
                    ", version=" + version +
                    ", regEx='" + regEx + '\'' +
                    ", exceptionCodes='" + exceptionCodes + '\'' +
                    ", scriptCodes='" + scriptCodes + '\'' +
                    ", purchasePageDivCss='" + purchasePageDivCss + '\'' +
                    ", validCookieKeys='" + validCookieKeys + '\'' +
                    ", isWebviewLogin=" + isWebviewLogin +
                    ", loginParams='" + loginParams + '\'' +
                    ", domain='" + domain + '\'' +
                    ", purchaseUrl='" + purchaseUrl + '\'' +
                    ", loginUrl='" + loginUrl + '\'' +
                    ", displayName='" + displayName + '\'' +
                    ", name='" + name + '\'' +
                    ", id=" + id +
                    '}';
        }
    }
}
