/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.lighthouse.v20200324.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DeleteFirewallTemplateRulesRequest extends AbstractModel {

    /**
    * 防火墙模板ID。
    */
    @SerializedName("TemplateId")
    @Expose
    private String TemplateId;

    /**
    * 防火墙模板规则ID列表。
    */
    @SerializedName("TemplateRuleIds")
    @Expose
    private String [] TemplateRuleIds;

    /**
     * Get 防火墙模板ID。 
     * @return TemplateId 防火墙模板ID。
     */
    public String getTemplateId() {
        return this.TemplateId;
    }

    /**
     * Set 防火墙模板ID。
     * @param TemplateId 防火墙模板ID。
     */
    public void setTemplateId(String TemplateId) {
        this.TemplateId = TemplateId;
    }

    /**
     * Get 防火墙模板规则ID列表。 
     * @return TemplateRuleIds 防火墙模板规则ID列表。
     */
    public String [] getTemplateRuleIds() {
        return this.TemplateRuleIds;
    }

    /**
     * Set 防火墙模板规则ID列表。
     * @param TemplateRuleIds 防火墙模板规则ID列表。
     */
    public void setTemplateRuleIds(String [] TemplateRuleIds) {
        this.TemplateRuleIds = TemplateRuleIds;
    }

    public DeleteFirewallTemplateRulesRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DeleteFirewallTemplateRulesRequest(DeleteFirewallTemplateRulesRequest source) {
        if (source.TemplateId != null) {
            this.TemplateId = new String(source.TemplateId);
        }
        if (source.TemplateRuleIds != null) {
            this.TemplateRuleIds = new String[source.TemplateRuleIds.length];
            for (int i = 0; i < source.TemplateRuleIds.length; i++) {
                this.TemplateRuleIds[i] = new String(source.TemplateRuleIds[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TemplateId", this.TemplateId);
        this.setParamArraySimple(map, prefix + "TemplateRuleIds.", this.TemplateRuleIds);

    }
}

