/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VulDefenceRangeDetail extends AbstractModel {

    /**
    * 漏洞名称
    */
    @SerializedName("VulName")
    @Expose
    private String VulName;

    /**
    * 标签
    */
    @SerializedName("Label")
    @Expose
    private String Label;

    /**
    * 漏洞级别：  1低危 2中危 3高危 4严重
    */
    @SerializedName("Level")
    @Expose
    private Long Level;

    /**
    * cvss 分数
    */
    @SerializedName("CvssScore")
    @Expose
    private Float CvssScore;

    /**
    * cve id
    */
    @SerializedName("CveId")
    @Expose
    private String CveId;

    /**
    * 发布时间
    */
    @SerializedName("PublishTime")
    @Expose
    private String PublishTime;

    /**
    * 漏洞id
    */
    @SerializedName("VulId")
    @Expose
    private Long VulId;

    /**
     * Get 漏洞名称 
     * @return VulName 漏洞名称
     */
    public String getVulName() {
        return this.VulName;
    }

    /**
     * Set 漏洞名称
     * @param VulName 漏洞名称
     */
    public void setVulName(String VulName) {
        this.VulName = VulName;
    }

    /**
     * Get 标签 
     * @return Label 标签
     */
    public String getLabel() {
        return this.Label;
    }

    /**
     * Set 标签
     * @param Label 标签
     */
    public void setLabel(String Label) {
        this.Label = Label;
    }

    /**
     * Get 漏洞级别：  1低危 2中危 3高危 4严重 
     * @return Level 漏洞级别：  1低危 2中危 3高危 4严重
     */
    public Long getLevel() {
        return this.Level;
    }

    /**
     * Set 漏洞级别：  1低危 2中危 3高危 4严重
     * @param Level 漏洞级别：  1低危 2中危 3高危 4严重
     */
    public void setLevel(Long Level) {
        this.Level = Level;
    }

    /**
     * Get cvss 分数 
     * @return CvssScore cvss 分数
     */
    public Float getCvssScore() {
        return this.CvssScore;
    }

    /**
     * Set cvss 分数
     * @param CvssScore cvss 分数
     */
    public void setCvssScore(Float CvssScore) {
        this.CvssScore = CvssScore;
    }

    /**
     * Get cve id 
     * @return CveId cve id
     */
    public String getCveId() {
        return this.CveId;
    }

    /**
     * Set cve id
     * @param CveId cve id
     */
    public void setCveId(String CveId) {
        this.CveId = CveId;
    }

    /**
     * Get 发布时间 
     * @return PublishTime 发布时间
     */
    public String getPublishTime() {
        return this.PublishTime;
    }

    /**
     * Set 发布时间
     * @param PublishTime 发布时间
     */
    public void setPublishTime(String PublishTime) {
        this.PublishTime = PublishTime;
    }

    /**
     * Get 漏洞id 
     * @return VulId 漏洞id
     */
    public Long getVulId() {
        return this.VulId;
    }

    /**
     * Set 漏洞id
     * @param VulId 漏洞id
     */
    public void setVulId(Long VulId) {
        this.VulId = VulId;
    }

    public VulDefenceRangeDetail() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VulDefenceRangeDetail(VulDefenceRangeDetail source) {
        if (source.VulName != null) {
            this.VulName = new String(source.VulName);
        }
        if (source.Label != null) {
            this.Label = new String(source.Label);
        }
        if (source.Level != null) {
            this.Level = new Long(source.Level);
        }
        if (source.CvssScore != null) {
            this.CvssScore = new Float(source.CvssScore);
        }
        if (source.CveId != null) {
            this.CveId = new String(source.CveId);
        }
        if (source.PublishTime != null) {
            this.PublishTime = new String(source.PublishTime);
        }
        if (source.VulId != null) {
            this.VulId = new Long(source.VulId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "VulName", this.VulName);
        this.setParamSimple(map, prefix + "Label", this.Label);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "CvssScore", this.CvssScore);
        this.setParamSimple(map, prefix + "CveId", this.CveId);
        this.setParamSimple(map, prefix + "PublishTime", this.PublishTime);
        this.setParamSimple(map, prefix + "VulId", this.VulId);

    }
}

