/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.ziputils.ziputil;

import com.tencent.tinker.ziputils.ziputil.BufferIterator;
import com.tencent.tinker.ziputils.ziputil.HeapBufferIterator;
import com.tencent.tinker.ziputils.ziputil.StandardCharsets;
import com.tencent.tinker.ziputils.ziputil.Streams;
import com.tencent.tinker.ziputils.ziputil.TinkerZipEntry;
import com.tencent.tinker.ziputils.ziputil.ZipConstants;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.ZipException;

public class TinkerZipFile
implements Closeable,
ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    static final int GPBF_ENCRYPTED_FLAG = 1;
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    static final int GPBF_UNSUPPORTED_MASK = 1;
    private final String filename;
    private final LinkedHashMap<String, TinkerZipEntry> entries = new LinkedHashMap();
    private File fileToDeleteOnClose;
    private RandomAccessFile raf;
    private String comment;

    public TinkerZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public TinkerZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public TinkerZipFile(File file, int mode) throws IOException {
        this.filename = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 4) != 0) {
            this.fileToDeleteOnClose = file;
            this.fileToDeleteOnClose.deleteOnExit();
        } else {
            this.fileToDeleteOnClose = null;
        }
        this.raf = new RandomAccessFile(this.filename, "r");
        this.readCentralDir();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            if (a instanceof String && b instanceof String) {
                return a.equals(b);
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static EocdRecord parseEocdRecord(RandomAccessFile raf, long offset, boolean isZip64) throws IOException {
        long centralDirOffset;
        long numEntries;
        raf.seek(offset);
        byte[] eocd = new byte[18];
        raf.readFully(eocd);
        BufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        if (isZip64) {
            numEntries = -1L;
            centralDirOffset = -1L;
            it.skip(16);
        } else {
            int diskNumber = it.readShort() & 0xFFFF;
            int diskWithCentralDir = it.readShort() & 0xFFFF;
            numEntries = it.readShort() & 0xFFFF;
            int totalNumEntries = it.readShort() & 0xFFFF;
            it.skip(4);
            centralDirOffset = (long)it.readInt() & 0xFFFFFFFFL;
            if (numEntries != (long)totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
                throw new ZipException("Spanned archives not supported");
            }
        }
        int commentLength = it.readShort() & 0xFFFF;
        return new EocdRecord(numEntries, centralDirOffset, commentLength);
    }

    static void throwZipException(String filename, long fileSize, String entryName, long localHeaderRelOffset, String msg, int magic) throws ZipException {
        String hexString = Integer.toHexString(magic);
        throw new ZipException("file name:" + filename + ", file size" + fileSize + ", entry name:" + entryName + ", entry localHeaderRelOffset:" + localHeaderRelOffset + ", " + msg + " signature not found; was " + hexString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RandomAccessFile localRaf = this.raf;
        if (localRaf != null) {
            RandomAccessFile randomAccessFile = localRaf;
            synchronized (randomAccessFile) {
                this.raf = null;
                localRaf.close();
            }
            if (this.fileToDeleteOnClose != null) {
                this.fileToDeleteOnClose.delete();
                this.fileToDeleteOnClose = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.raf == null) {
            throw new IllegalStateException("Zip file closed");
        }
    }

    public Enumeration<? extends TinkerZipEntry> entries() {
        this.checkNotClosed();
        final Iterator<TinkerZipEntry> iterator = this.entries.values().iterator();
        return new Enumeration<TinkerZipEntry>(){

            @Override
            public boolean hasMoreElements() {
                TinkerZipFile.this.checkNotClosed();
                return iterator.hasNext();
            }

            @Override
            public TinkerZipEntry nextElement() {
                TinkerZipFile.this.checkNotClosed();
                return (TinkerZipEntry)iterator.next();
            }
        };
    }

    public String getComment() {
        this.checkNotClosed();
        return this.comment;
    }

    public TinkerZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException("entryName == null");
        }
        TinkerZipEntry ze = this.entries.get(entryName);
        if (ze == null) {
            ze = this.entries.get(entryName + "/");
        }
        return ze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(TinkerZipEntry entry) throws IOException {
        RandomAccessFile localRaf;
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = localRaf = this.raf;
        synchronized (randomAccessFile) {
            RAFStream rafStream = new RAFStream(localRaf, entry.localHeaderRelOffset);
            DataInputStream is = new DataInputStream(rafStream);
            int localMagic = Integer.reverseBytes(is.readInt());
            if ((long)localMagic != 67324752L) {
                TinkerZipFile.throwZipException(this.filename, localRaf.length(), entry.getName(), entry.localHeaderRelOffset, "Local File Header", localMagic);
            }
            is.skipBytes(2);
            int gpbf = Short.reverseBytes(is.readShort()) & 0xFFFF;
            if ((gpbf & 1) != 0) {
                throw new ZipException("Invalid General Purpose Bit Flag: " + gpbf);
            }
            is.skipBytes(18);
            int fileNameLength = Short.reverseBytes(is.readShort()) & 0xFFFF;
            int extraFieldLength = Short.reverseBytes(is.readShort()) & 0xFFFF;
            is.close();
            rafStream.skip(fileNameLength + extraFieldLength);
            if (entry.compressionMethod == 0) {
                rafStream.endOffset = rafStream.offset + entry.size;
            } else {
                rafStream.endOffset = rafStream.offset + entry.compressedSize;
            }
            return rafStream;
        }
    }

    public String getName() {
        return this.filename;
    }

    public int size() {
        this.checkNotClosed();
        return this.entries.size();
    }

    private void readCentralDir() throws IOException {
        block8: {
            long scanOffset = this.raf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + this.raf.length());
            }
            this.raf.seek(0L);
            int headerMagic = Integer.reverseBytes(this.raf.readInt());
            if ((long)headerMagic != 67324752L) {
                throw new ZipException("Not a zip archive");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            do {
                this.raf.seek(scanOffset);
                if ((long)Integer.reverseBytes(this.raf.readInt()) == 101010256L) break block8;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        byte[] eocd = new byte[18];
        this.raf.readFully(eocd);
        BufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        int diskNumber = it.readShort() & 0xFFFF;
        int diskWithCentralDir = it.readShort() & 0xFFFF;
        int numEntries = it.readShort() & 0xFFFF;
        int totalNumEntries = it.readShort() & 0xFFFF;
        it.skip(4);
        long centralDirOffset = (long)it.readInt() & 0xFFFFFFFFL;
        int commentLength = it.readShort() & 0xFFFF;
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("Spanned archives not supported");
        }
        if (commentLength > 0) {
            byte[] commentBytes = new byte[commentLength];
            this.raf.readFully(commentBytes);
            this.comment = new String(commentBytes, 0, commentBytes.length, StandardCharsets.UTF_8);
        }
        RAFStream rafStream = new RAFStream(this.raf, centralDirOffset);
        BufferedInputStream bufferedStream = new BufferedInputStream(rafStream, 4096);
        byte[] hdrBuf = new byte[46];
        for (int i = 0; i < numEntries; ++i) {
            TinkerZipEntry newEntry = new TinkerZipEntry(hdrBuf, bufferedStream, StandardCharsets.UTF_8, false);
            if (newEntry.localHeaderRelOffset >= centralDirOffset) {
                throw new ZipException("Local file header offset is after central directory");
            }
            String entryName = newEntry.getName();
            if (this.entries.put(entryName, newEntry) == null) continue;
            throw new ZipException("Duplicate entry name: " + entryName);
        }
    }

    public static class RAFStream
    extends InputStream {
        private final RandomAccessFile sharedRaf;
        private long endOffset;
        private long offset;

        public RAFStream(RandomAccessFile raf, long initialOffset, long endOffset) {
            this.sharedRaf = raf;
            this.offset = initialOffset;
            this.endOffset = endOffset;
        }

        public RAFStream(RandomAccessFile raf, long initialOffset) throws IOException {
            this(raf, initialOffset, raf.length());
        }

        @Override
        public int available() throws IOException {
            return this.offset < this.endOffset ? 1 : 0;
        }

        @Override
        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            RandomAccessFile randomAccessFile = this.sharedRaf;
            synchronized (randomAccessFile) {
                long length = this.endOffset - this.offset;
                if ((long)byteCount > length) {
                    byteCount = (int)length;
                }
                this.sharedRaf.seek(this.offset);
                int count = this.sharedRaf.read(buffer, byteOffset, byteCount);
                if (count > 0) {
                    this.offset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        @Override
        public long skip(long byteCount) throws IOException {
            if (byteCount > this.endOffset - this.offset) {
                byteCount = this.endOffset - this.offset;
            }
            this.offset += byteCount;
            return byteCount;
        }
    }

    static class EocdRecord {
        final long numEntries;
        final long centralDirOffset;
        final int commentLength;

        EocdRecord(long numEntries, long centralDirOffset, int commentLength) {
            this.numEntries = numEntries;
            this.centralDirOffset = centralDirOffset;
            this.commentLength = commentLength;
        }
    }
}

