/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import java.io.File;
import java.io.IOException;

public class Logger {
    private static InfoWriter logWriter;

    public static void initLogger(Configuration config) throws IOException {
        String logPath = config.mOutFolder + File.separator + "log.txt";
        logWriter = new InfoWriter(config, logPath);
    }

    public static void closeLogger() {
        if (logWriter != null) {
            logWriter.close();
        }
    }

    public static void d(String msg) {
        Logger.d("%s", msg);
    }

    public static void d(String format, Object ... obj) {
        String log;
        String string = log = obj.length == 0 ? format : String.format(format, obj);
        if (log == null) {
            log = "";
        }
        System.out.println(log);
        System.out.flush();
        logWriter.writeLineToInfoFile(log);
    }

    public static void e(String msg) {
        Logger.e("%s", msg);
    }

    public static void e(String format, Object ... obj) {
        String log;
        String string = log = obj.length == 0 ? format : String.format(format, obj);
        if (log == null) {
            log = "";
        }
        System.err.println(log);
        System.err.flush();
        logWriter.writeLineToInfoFile(log);
    }
}

