/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.patch;

import com.tencent.tinker.build.builder.PatchBuilder;
import com.tencent.tinker.build.decoder.ApkDecoder;
import com.tencent.tinker.build.info.PatchInfo;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.patch.InputParam;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import java.io.IOException;

public class Runner {
    public static final int ERRNO_ERRORS = 1;
    public static final int ERRNO_USAGE = 2;
    private final boolean mIsGradleEnv;
    protected static long mBeginTime;
    protected Configuration mConfig;

    public Runner(boolean isGradleEnv) {
        this.mIsGradleEnv = isGradleEnv;
    }

    public static void gradleRun(InputParam inputParam) {
        mBeginTime = System.currentTimeMillis();
        Runner m = new Runner(true);
        m.run(inputParam);
    }

    private void run(InputParam inputParam) {
        this.loadConfigFromGradle(inputParam);
        try {
            Logger.initLogger(this.mConfig);
            this.tinkerPatch();
        }
        catch (IOException e) {
            this.goToError(e, 1);
        }
        finally {
            Logger.closeLogger();
        }
    }

    protected void tinkerPatch() {
        Logger.d("-----------------------Tinker patch begin-----------------------");
        Logger.d(this.mConfig.toString());
        try {
            ApkDecoder decoder = new ApkDecoder(this.mConfig);
            decoder.onAllPatchesStart();
            decoder.patch(this.mConfig.mOldApkFile, this.mConfig.mNewApkFile);
            decoder.onAllPatchesEnd();
            PatchInfo info = new PatchInfo(this.mConfig);
            info.gen();
            PatchBuilder builder = new PatchBuilder(this.mConfig);
            builder.buildPatch();
        }
        catch (Throwable e) {
            this.goToError(e, 2);
        }
        Logger.d("Tinker patch done, total time cost: %fs", this.diffTimeFromBegin());
        Logger.d("Tinker patch done, you can go to file to find the output %s", this.mConfig.mOutFolder);
        Logger.d("-----------------------Tinker patch end-------------------------");
    }

    private void loadConfigFromGradle(InputParam inputParam) {
        try {
            this.mConfig = new Configuration(inputParam);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TinkerPatchException e) {
            e.printStackTrace();
        }
    }

    public void goToError(Throwable thr, int errCode) {
        if (this.mIsGradleEnv) {
            throw new RuntimeException(thr);
        }
        thr.printStackTrace(System.err);
        System.exit(errCode);
    }

    public double diffTimeFromBegin() {
        long end = System.currentTimeMillis();
        return (double)(end - mBeginTime) / 1000.0;
    }
}

